import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState } from 'react'; // import { action } from '@storybook/addon-actions';
// import { withKnobs, boolean, number, text } from '@storybook/addon-knobs';

import { default as Slider, SliderSkeleton } from '../../Slider'; // import { sliderValuePropSync } from '../../../../react/src/internal/FeatureFlags';

import { Layer } from '../../Layer';
import mdx from './Slider.mdx';
export default {
  title: 'Components/Slider',
  parameters: {
    component: Slider,
    docs: {
      page: mdx
    },
    subcomponents: {
      SliderSkeleton: SliderSkeleton
    }
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(Slider, {
    labelText: "Slider Label",
    value: 50,
    min: 0,
    max: 100,
    step: 1,
    stepMultiplier: 10,
    novalidate: true
  });
};
Default.story = {
  name: 'Slider'
};
export var ControlledSlider = function ControlledSlider() {
  var _useState = useState(87),
      _useState2 = _slicedToArray(_useState, 2),
      val = _useState2[0],
      setVal = _useState2[1];

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("button", {
    type: "button",
    onClick: function onClick() {
      return setVal(Math.round(Math.random() * 100));
    }
  }, "randomize value"), /*#__PURE__*/React.createElement(Slider, {
    max: 100,
    min: 0,
    value: val,
    onChange: function onChange(_ref) {
      var value = _ref.value;
      return setVal(value);
    }
  }), /*#__PURE__*/React.createElement("h1", null, val));
};
export var withLayer = function withLayer() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Slider, {
    labelText: "First Layer",
    value: 50,
    min: 0,
    max: 100,
    step: 1,
    stepMultiplier: 10,
    novalidate: true
  }), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(Slider, {
    labelText: "Second Layer",
    value: 50,
    min: 0,
    max: 100,
    step: 1,
    stepMultiplier: 10,
    novalidate: true
  }), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(Slider, {
    labelText: "Third Layer",
    value: 50,
    min: 0,
    max: 100,
    step: 1,
    stepMultiplier: 10,
    novalidate: true
  }))));
};
export var ControlledSliderWithLayer = function ControlledSliderWithLayer() {
  var _useState3 = useState(87),
      _useState4 = _slicedToArray(_useState3, 2),
      val = _useState4[0],
      setVal = _useState4[1];

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("button", {
    type: "button",
    onClick: function onClick() {
      return setVal(Math.round(Math.random() * 100));
    }
  }, "randomize value"), /*#__PURE__*/React.createElement(Slider, {
    max: 100,
    min: 0,
    value: val,
    onChange: function onChange(_ref2) {
      var value = _ref2.value;
      return setVal(value);
    }
  }), /*#__PURE__*/React.createElement("h1", null, val), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement("button", {
    type: "button",
    onClick: function onClick() {
      return setVal(Math.round(Math.random() * 100));
    }
  }, "randomize value"), /*#__PURE__*/React.createElement(Slider, {
    max: 100,
    min: 0,
    value: val,
    onChange: function onChange(_ref3) {
      var value = _ref3.value;
      return setVal(value);
    }
  }), /*#__PURE__*/React.createElement("h1", null, val), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement("button", {
    type: "button",
    onClick: function onClick() {
      return setVal(Math.round(Math.random() * 100));
    }
  }, "randomize value"), /*#__PURE__*/React.createElement(Slider, {
    max: 100,
    min: 0,
    value: val,
    onChange: function onChange(_ref4) {
      var value = _ref4.value;
      return setVal(value);
    }
  }), /*#__PURE__*/React.createElement("h1", null, val))));
};
export var Skeleton = function Skeleton() {
  return /*#__PURE__*/React.createElement(SliderSkeleton, null);
};