/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { default as TextArea, TextAreaSkeleton } from '../';
import { Layer } from '../../Layer';
export default {
  title: 'Components/TextArea',
  parameters: {
    component: TextArea,
    subcomponents: {
      TextAreaSkeleton: TextAreaSkeleton
    }
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(TextArea, {
    labelText: "Text Area label",
    helperText: "Optional helper text",
    placeholder: "Placeholder text",
    cols: 50,
    rows: 4,
    id: "text-area-1"
  });
};
export var withLayer = function withLayer() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(TextArea, {
    labelText: "First layer",
    helperText: "Optional helper text",
    placeholder: "Placeholder text",
    cols: 50,
    rows: 4,
    id: "text-area-1"
  }), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(TextArea, {
    labelText: "Second layer",
    helperText: "Optional helper text",
    placeholder: "Placeholder text",
    cols: 50,
    rows: 4,
    id: "text-area-1"
  }), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(TextArea, {
    labelText: "Third layer",
    helperText: "Optional helper text",
    placeholder: "Placeholder text",
    cols: 50,
    rows: 4,
    id: "text-area-1"
  }))));
};
export var Skeleton = function Skeleton() {
  return /*#__PURE__*/React.createElement(TextAreaSkeleton, null);
};