/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import './Theme-story.scss';
import React from 'react';
import { Theme, useTheme } from '../../Theme';
import { Layer } from '../../Layer';
import mdx from './Theme.mdx';
export default {
  title: 'Components/Theme',
  component: Theme,
  parameters: {
    controls: {
      hideNoControlsWarning: true
    },
    docs: {
      page: mdx
    }
  },
  argTypes: {
    as: {
      table: {
        disable: true
      }
    },
    children: {
      table: {
        disable: true
      }
    },
    theme: {
      defaultValue: 'g10'
    }
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Theme, {
    theme: "g100"
  }, /*#__PURE__*/React.createElement("section", {
    className: "theme-section"
  }, /*#__PURE__*/React.createElement("p", null, "g100 theme"))), /*#__PURE__*/React.createElement(Theme, {
    theme: "g90"
  }, /*#__PURE__*/React.createElement("section", {
    className: "theme-section"
  }, /*#__PURE__*/React.createElement("p", null, "g90 theme"))), /*#__PURE__*/React.createElement(Theme, {
    theme: "g10"
  }, /*#__PURE__*/React.createElement("section", {
    className: "theme-section"
  }, /*#__PURE__*/React.createElement("p", null, "g10 theme"))), /*#__PURE__*/React.createElement(Theme, {
    theme: "white"
  }, /*#__PURE__*/React.createElement("section", {
    className: "theme-section"
  }, /*#__PURE__*/React.createElement("p", null, "white theme"))));
};
export var UseTheme = function UseTheme() {
  function Example() {
    var _useTheme = useTheme(),
        theme = _useTheme.theme;

    return /*#__PURE__*/React.createElement("div", {
      className: "theme-section"
    }, "The current theme is: ", theme);
  }

  return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(Example, null), /*#__PURE__*/React.createElement(Theme, {
    theme: "g100"
  }, /*#__PURE__*/React.createElement(Example, null)));
};
UseTheme.storyName = 'useTheme';
export var WithLayer = function WithLayer() {
  function Layers() {
    var _useTheme2 = useTheme(),
        theme = _useTheme2.theme;

    return /*#__PURE__*/React.createElement("article", {
      className: "theme-layer-example"
    }, /*#__PURE__*/React.createElement("header", {
      className: "theme-layer-header"
    }, theme, " theme"), /*#__PURE__*/React.createElement("div", {
      className: "theme-with-layer"
    }, "Layer one"), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement("div", {
      className: "theme-with-layer"
    }, "Layer two"), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement("div", {
      className: "theme-with-layer"
    }, "Layer three"))));
  }

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Layers, null), /*#__PURE__*/React.createElement(Theme, {
    theme: "g10"
  }, /*#__PURE__*/React.createElement(Layers, null), /*#__PURE__*/React.createElement(Theme, {
    theme: "g90"
  }, /*#__PURE__*/React.createElement(Layers, null), /*#__PURE__*/React.createElement(Theme, {
    theme: "g100"
  }, /*#__PURE__*/React.createElement(Layers, null)))));
};

var PlaygroundStory = function PlaygroundStory(args) {
  return /*#__PURE__*/React.createElement(Theme, args, /*#__PURE__*/React.createElement("section", {
    className: "theme-section"
  }, /*#__PURE__*/React.createElement("p", null, args.theme, " theme")));
};

export var Playground = PlaygroundStory.bind({});