import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

var _defineProperty2;

var _excluded = ["aria-label", "children", "className", "disabled", "hideLabel", "id", "iconDescription", "labelText"];

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React, { Component } from 'react';
import classNames from 'classnames';
import { ChevronDown16 } from '@carbon/icons-react';
import { settings } from 'carbon-components';
import deprecate from '../../prop-types/deprecate';
var prefix = settings.prefix;

var TimePickerSelect = /*#__PURE__*/function (_Component) {
  _inherits(TimePickerSelect, _Component);

  var _super = _createSuper(TimePickerSelect);

  function TimePickerSelect() {
    _classCallCheck(this, TimePickerSelect);

    return _super.apply(this, arguments);
  }

  _createClass(TimePickerSelect, [{
    key: "render",
    value: function render() {
      var _classNames;

      var _this$props = this.props,
          _this$props$ariaLabe = _this$props['aria-label'],
          ariaLabel = _this$props$ariaLabe === void 0 ? 'open list of options' : _this$props$ariaLabe,
          children = _this$props.children,
          className = _this$props.className,
          disabled = _this$props.disabled,
          _this$props$hideLabel = _this$props.hideLabel,
          hideLabel = _this$props$hideLabel === void 0 ? true : _this$props$hideLabel,
          id = _this$props.id,
          iconDescription = _this$props.iconDescription,
          labelText = _this$props.labelText,
          rest = _objectWithoutProperties(_this$props, _excluded);

      var selectClasses = classNames((_classNames = {}, _defineProperty(_classNames, "".concat(prefix, "--select"), true), _defineProperty(_classNames, "".concat(prefix, "--time-picker__select"), true), _defineProperty(_classNames, className, className), _classNames));
      var labelClasses = classNames("".concat(prefix, "--label"), _defineProperty({}, "".concat(prefix, "--visually-hidden"), hideLabel));
      var label = labelText ? /*#__PURE__*/React.createElement("label", {
        htmlFor: id,
        className: labelClasses
      }, labelText) : null;
      return /*#__PURE__*/React.createElement("div", {
        className: selectClasses
      }, label, /*#__PURE__*/React.createElement("select", _extends({
        className: "".concat(prefix, "--select-input"),
        disabled: disabled,
        id: id,
        "aria-label": ariaLabel
      }, rest), children), /*#__PURE__*/React.createElement(ChevronDown16, {
        className: "".concat(prefix, "--select__arrow"),
        "aria-label": ariaLabel ? ariaLabel : iconDescription
      }));
    }
  }]);

  return TimePickerSelect;
}(Component);

_defineProperty(TimePickerSelect, "propTypes", (_defineProperty2 = {}, _defineProperty(_defineProperty2, 'aria-label', PropTypes.string), _defineProperty(_defineProperty2, "children", PropTypes.node), _defineProperty(_defineProperty2, "className", PropTypes.string), _defineProperty(_defineProperty2, "defaultValue", PropTypes.any), _defineProperty(_defineProperty2, "disabled", PropTypes.bool), _defineProperty(_defineProperty2, "hideLabel", deprecate(PropTypes.bool, 'The `hideLabel` prop for `TimePickerSelect` is no longer needed and has ' + 'been deprecated. It will be removed in the next major release.')), _defineProperty(_defineProperty2, "iconDescription", deprecate(PropTypes.string, 'The `iconDescription` prop for `TimePickerSelect` is no longer needed and has ' + 'been deprecated. It will be removed in the next major release. Use `aria-label` instead.')), _defineProperty(_defineProperty2, "id", PropTypes.string.isRequired), _defineProperty(_defineProperty2, "labelText", PropTypes.node.isRequired), _defineProperty2));

_defineProperty(TimePickerSelect, "defaultProps", {
  disabled: false
});

export { TimePickerSelect as default };