import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "defaultToggled", "disabled", "hideLabel", "id", "labelA", "labelB", "labelText", "onClick", "onToggle", "size", "toggled"];

/**
 * Copyright IBM Corp. 2021
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { settings } from 'carbon-components';
import { useControllableState } from '../../../internal/useControllableState';
var prefix = settings.prefix;
export function Toggle(_ref) {
  var className = _ref.className,
      _ref$defaultToggled = _ref.defaultToggled,
      defaultToggled = _ref$defaultToggled === void 0 ? false : _ref$defaultToggled,
      _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled,
      _ref$hideLabel = _ref.hideLabel,
      hideLabel = _ref$hideLabel === void 0 ? false : _ref$hideLabel,
      id = _ref.id,
      _ref$labelA = _ref.labelA,
      labelA = _ref$labelA === void 0 ? 'Off' : _ref$labelA,
      _ref$labelB = _ref.labelB,
      labelB = _ref$labelB === void 0 ? 'On' : _ref$labelB,
      labelText = _ref.labelText,
      onClick = _ref.onClick,
      onToggle = _ref.onToggle,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'md' : _ref$size,
      toggled = _ref.toggled,
      other = _objectWithoutProperties(_ref, _excluded);

  var _useControllableState = useControllableState({
    value: toggled,
    onChange: onToggle,
    defaultValue: defaultToggled
  }),
      _useControllableState2 = _slicedToArray(_useControllableState, 2),
      checked = _useControllableState2[0],
      setChecked = _useControllableState2[1];

  function handleClick(e) {
    setChecked(!checked);

    if (onClick) {
      onClick(e);
    }
  }

  var isSm = size === 'sm';
  var sideLabel = hideLabel ? labelText : checked ? labelB : labelA;
  var wrapperClasses = classNames("".concat(prefix, "--toggle"), _defineProperty({}, "".concat(prefix, "--toggle--disabled"), disabled), className);
  var labelTextClasses = classNames("".concat(prefix, "--toggle__label-text"), _defineProperty({}, "".concat(prefix, "--visually-hidden"), hideLabel));
  var appearanceClasses = classNames("".concat(prefix, "--toggle__appearance"), _defineProperty({}, "".concat(prefix, "--toggle__appearance--sm"), isSm));
  var switchClasses = classNames("".concat(prefix, "--toggle__switch"), _defineProperty({}, "".concat(prefix, "--toggle__switch--checked"), checked));
  return /*#__PURE__*/React.createElement("div", {
    className: wrapperClasses
  }, /*#__PURE__*/React.createElement("button", _extends({}, other, {
    id: id,
    className: "".concat(prefix, "--toggle__button"),
    role: "switch",
    type: "button",
    "aria-checked": checked,
    disabled: disabled,
    onClick: handleClick
  })), /*#__PURE__*/React.createElement("label", {
    htmlFor: id,
    className: "".concat(prefix, "--toggle__label")
  }, /*#__PURE__*/React.createElement("span", {
    className: labelTextClasses
  }, labelText), /*#__PURE__*/React.createElement("div", {
    className: appearanceClasses
  }, /*#__PURE__*/React.createElement("div", {
    className: switchClasses
  }, isSm && /*#__PURE__*/React.createElement("svg", {
    className: "".concat(prefix, "--toggle__check"),
    width: "6px",
    height: "5px",
    viewBox: "0 0 6 5"
  }, /*#__PURE__*/React.createElement("path", {
    d: "M2.2 2.7L5 0 6 1 2.2 5 0 2.7 1 1.5z"
  }))), /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--toggle__text"),
    "aria-hidden": "true"
  }, sideLabel))));
}
Toggle.propTypes = {
  /**
   * Specify a custom className to apply to the form-item node
   */
  className: PropTypes.string,

  /**
   * Specify whether the toggle should be on by default
   */
  defaultToggled: PropTypes.bool,

  /**
   * Whether this control should be disabled
   */
  disabled: PropTypes.bool,

  /**
   * Specify whether the label should be hidden, or not
   */
  hideLabel: PropTypes.bool,

  /**
   * Provide an id that unique represents the underlying `<button>`
   */
  id: PropTypes.string.isRequired,

  /**
   * Specify the label for the "off" position
   */
  labelA: PropTypes.node,

  /**
   * Specify the label for the "on" position
   */
  labelB: PropTypes.node,

  /**
   * Provide the text that will be read by a screen reader when visiting this
   * control
   */
  labelText: PropTypes.node.isRequired,

  /**
   * Provide an event listener that is called when the control is clicked
   */
  onClick: PropTypes.func,

  /**
   * Provide an event listener that is called when the control is toggled
   */
  onToggle: PropTypes.func,

  /**
   * Specify the size of the Toggle. Currently only supports 'sm' or 'md' (default)
   */
  size: PropTypes.oneOf(['sm', 'md']),

  /**
   * Specify whether the control is toggled
   */
  toggled: PropTypes.bool
};
export default Toggle;