import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["className", "type", "id", "placeHolderText", "labelText", "role", "labelId"];

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { Search16 } from '@carbon/icons-react';
import { settings } from 'carbon-components';
import ClickListener from '../../internal/ClickListener';
import { warning } from '../../internal/warning';
var prefix = settings.prefix;
var didWarnAboutDeprecation = false;

var ToolbarSearch = /*#__PURE__*/function (_Component) {
  _inherits(ToolbarSearch, _Component);

  var _super = _createSuper(ToolbarSearch);

  function ToolbarSearch(props) {
    var _this;

    _classCallCheck(this, ToolbarSearch);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "state", {
      expanded: false
    });

    _defineProperty(_assertThisInitialized(_this), "expandSearch", function () {
      _this.setState({
        expanded: !_this.state.expanded
      });

      _this.input.focus();
    });

    _defineProperty(_assertThisInitialized(_this), "handleClickOutside", function () {
      _this.setState({
        expanded: false
      });
    });

    if (process.env.NODE_ENV !== "production") {
      process.env.NODE_ENV !== "production" ? warning(didWarnAboutDeprecation, 'The ToolbarSearch component has been deprecated and will be removed in the next major release of `carbon-components-react`') : void 0;
      didWarnAboutDeprecation = true;
    }

    return _this;
  }

  _createClass(ToolbarSearch, [{
    key: "render",
    value: function render() {
      var _classNames,
          _this2 = this;

      var _this$props = this.props,
          className = _this$props.className,
          type = _this$props.type,
          id = _this$props.id,
          placeHolderText = _this$props.placeHolderText,
          labelText = _this$props.labelText,
          role = _this$props.role,
          labelId = _this$props.labelId,
          other = _objectWithoutProperties(_this$props, _excluded);

      var searchClasses = classNames((_classNames = {}, _defineProperty(_classNames, "".concat(prefix, "--search ").concat(prefix, "--search--sm ").concat(prefix, "--toolbar-search"), true), _defineProperty(_classNames, "".concat(prefix, "--toolbar-search--active"), this.state.expanded), _defineProperty(_classNames, className, className), _classNames));
      return /*#__PURE__*/React.createElement(ClickListener, {
        onClickOutside: this.handleClickOutside
      }, /*#__PURE__*/React.createElement("div", {
        className: searchClasses,
        role: role
      }, /*#__PURE__*/React.createElement("label", {
        htmlFor: id,
        className: "".concat(prefix, "--label"),
        id: labelId
      }, labelText), /*#__PURE__*/React.createElement("input", _extends({}, other, {
        type: type,
        className: "".concat(prefix, "--search-input"),
        id: id,
        "aria-labelledby": labelId,
        placeholder: placeHolderText,
        ref: function ref(input) {
          _this2.input = input;
        }
      })), /*#__PURE__*/React.createElement("button", {
        type: "button",
        className: "".concat(prefix, "--toolbar-search__btn"),
        title: labelText,
        onClick: this.expandSearch
      }, /*#__PURE__*/React.createElement(Search16, {
        className: "".concat(prefix, "--search-magnifier"),
        "aria-label": labelText
      }))));
    }
  }]);

  return ToolbarSearch;
}(Component);

_defineProperty(ToolbarSearch, "propTypes", {
  /**
   * The child nodes.
   */
  children: PropTypes.node,

  /**
   * The CSS class names.
   */
  className: PropTypes.string,

  /**
   * The ID of the `<input>`.
   */
  id: PropTypes.string,

  /**
   * The ID of the `<label>`.
   */
  labelId: PropTypes.string,

  /**
   * The text in the `<label>`.
   */
  labelText: PropTypes.node,

  /**
   * The placeholder text of the `<input>`.
   */
  placeHolderText: PropTypes.string,

  /**
   * Optional prop to specify the role of the ToolbarSearch
   */
  role: PropTypes.string,

  /**
   * `true` to use the small version of the UI.
   */
  small: PropTypes.bool,

  /**
   * The `type` of the `<input>`.
   */
  type: PropTypes.string
});

_defineProperty(ToolbarSearch, "defaultProps", {
  type: 'search',
  id: 'search__input',
  labelText: '',
  placeHolderText: '',
  role: 'search',
  labelId: 'search__label'
});

export { ToolbarSearch as default };