import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["id", "className", "triggerClassName", "children", "direction", "align", "onBlur", "onFocus", "onMouseEnter", "onMouseLeave", "tooltipText"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import cx from 'classnames';
import React, { useState, useEffect } from 'react';
import PropTypes from 'prop-types';
import debounce from 'lodash.debounce';
import setupGetInstanceId from '../../tools/setupGetInstanceId';
import { composeEventHandlers } from '../../tools/events';
import { keys, matches } from '../../internal/keyboard';
import { usePrefix } from '../../internal/usePrefix';
var getInstanceId = setupGetInstanceId();

var TooltipDefinition = function TooltipDefinition(_ref) {
  var _cx;

  var id = _ref.id,
      className = _ref.className,
      triggerClassName = _ref.triggerClassName,
      children = _ref.children,
      direction = _ref.direction,
      align = _ref.align,
      onBlur = _ref.onBlur,
      onFocus = _ref.onFocus,
      onMouseEnter = _ref.onMouseEnter,
      onMouseLeave = _ref.onMouseLeave,
      tooltipText = _ref.tooltipText,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();

  var _useState = useState(true),
      _useState2 = _slicedToArray(_useState, 2),
      allowTooltipVisibility = _useState2[0],
      setAllowTooltipVisibility = _useState2[1];

  var _useState3 = useState(false),
      _useState4 = _slicedToArray(_useState3, 2),
      tooltipVisible = _useState4[0],
      setTooltipVisible = _useState4[1];

  var tooltipId = id || "definition-tooltip-".concat(getInstanceId());
  var tooltipClassName = cx("".concat(prefix, "--tooltip--definition"), "".concat(prefix, "--tooltip--a11y"), className);
  var tooltipTriggerClasses = cx("".concat(prefix, "--tooltip__trigger"), "".concat(prefix, "--tooltip--a11y"), "".concat(prefix, "--tooltip__trigger--definition"), triggerClassName, (_cx = {}, _defineProperty(_cx, "".concat(prefix, "--tooltip--").concat(direction), direction), _defineProperty(_cx, "".concat(prefix, "--tooltip--align-").concat(align), align), _defineProperty(_cx, "".concat(prefix, "--tooltip--hidden"), !allowTooltipVisibility), _defineProperty(_cx, "".concat(prefix, "--tooltip--visible"), tooltipVisible), _cx));
  var debounceTooltipVisible = debounce(function () {
    return setTooltipVisible(false);
  }, 100);

  var handleFocus = function handleFocus() {
    debounceTooltipVisible.cancel();
    setAllowTooltipVisibility(true);
    setTooltipVisible(true);
  };

  var handleBlur = debounceTooltipVisible;

  var handleMouseEnter = function handleMouseEnter() {
    debounceTooltipVisible.cancel();
    setAllowTooltipVisibility(true);
    setTooltipVisible(true);
  };

  var handleMouseLeave = debounceTooltipVisible;
  useEffect(function () {
    var handleEscKeyDown = function handleEscKeyDown(event) {
      if (matches(event, [keys.Escape])) {
        setAllowTooltipVisibility(false);
      }
    };

    document.addEventListener('keydown', handleEscKeyDown);
    return function () {
      return document.removeEventListener('keydown', handleEscKeyDown);
    };
  }, []);
  return /*#__PURE__*/React.createElement("span", _extends({}, rest, {
    className: tooltipClassName,
    onMouseEnter: composeEventHandlers([onMouseEnter, handleMouseEnter]),
    onMouseLeave: composeEventHandlers([onMouseLeave, handleMouseLeave])
  }), /*#__PURE__*/React.createElement("button", {
    type: "button",
    className: tooltipTriggerClasses,
    "aria-describedby": tooltipId,
    onFocus: composeEventHandlers([onFocus, handleFocus]),
    onBlur: composeEventHandlers([onBlur, handleBlur])
  }, children), /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--assistive-text"),
    id: tooltipId,
    role: "tooltip"
  }, tooltipText));
};

TooltipDefinition.propTypes = {
  /**
   * Specify the alignment (to the trigger button) of the tooltip.
   * Can be one of: start, center, or end.
   */
  align: PropTypes.oneOf(['start', 'center', 'end']),

  /**
   * Specify the tooltip trigger text that is rendered to the UI for the user to
   * interact with in order to display the tooltip.
   */
  children: PropTypes.node.isRequired,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: PropTypes.string,

  /**
   * Specify the direction of the tooltip. Can be either top or bottom.
   */
  direction: PropTypes.oneOf(['top', 'bottom']),

  /**
   * Optionally specify a custom id for the tooltip. If one is not provided, we
   * generate a unique id for you.
   */
  id: PropTypes.string,

  /**
   * The event handler for the `blur` event.
   */
  onBlur: PropTypes.func,

  /**
   * The event handler for the `focus` event.
   */
  onFocus: PropTypes.func,

  /**
   * The event handler for the `mouseenter` event.
   */
  onMouseEnter: PropTypes.func,

  /**
   * The event handler for the `mouseleave` event.
   */
  onMouseLeave: PropTypes.func,

  /**
   * Provide the text that will be displayed in the tooltip when it is rendered.
   * TODO: rename this prop (will be a breaking change)
   */
  tooltipText: PropTypes.node.isRequired,

  /**
   * The CSS class name of the trigger element
   */
  triggerClassName: PropTypes.string
};
TooltipDefinition.defaultProps = {
  direction: 'bottom',
  align: 'start'
};
export default TooltipDefinition;