import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "href", "tabIndex"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import cx from 'classnames';
import React from 'react';
import PropTypes from 'prop-types';
import { usePrefix } from '../../internal/usePrefix';

var SkipToContent = function SkipToContent(_ref) {
  var children = _ref.children,
      customClassName = _ref.className,
      href = _ref.href,
      tabIndex = _ref.tabIndex,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var className = cx("".concat(prefix, "--skip-to-content"), customClassName);
  return /*#__PURE__*/React.createElement("a", _extends({}, rest, {
    className: className,
    href: href,
    tabIndex: tabIndex
  }), children);
};

SkipToContent.propTypes = {
  /**
   * Provide text to display in the SkipToContent `a` tag
   */
  children: PropTypes.string.isRequired,
  className: PropTypes.string,

  /**
   * Provide the `href` to the id of the element on your package that is the
   * main content.
   */
  href: PropTypes.string.isRequired,

  /**
   * Optionally override the default tabindex of 0
   */
  tabIndex: PropTypes.string
};
SkipToContent.defaultProps = {
  children: 'Skip to main content',
  href: '#main-content',
  tabIndex: '0'
};
export default SkipToContent;