import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { ChevronDown20 } from '@carbon/icons-react';
import cx from 'classnames';
import PropTypes from 'prop-types';
import React, { useState } from 'react';
import SideNavIcon from '../SideNavIcon';
import { keys, match } from '../../../internal/keyboard';
import { usePrefix } from '../../../internal/usePrefix';
var SideNavMenu = /*#__PURE__*/React.forwardRef(function SideNavMenu(props, ref) {
  var _cx;

  var customClassName = props.className,
      children = props.children,
      _props$defaultExpande = props.defaultExpanded,
      defaultExpanded = _props$defaultExpande === void 0 ? false : _props$defaultExpande,
      _props$isActive = props.isActive,
      isActive = _props$isActive === void 0 ? false : _props$isActive,
      _props$large = props.large,
      large = _props$large === void 0 ? false : _props$large,
      IconElement = props.renderIcon,
      isSideNavExpanded = props.isSideNavExpanded,
      title = props.title;
  var prefix = usePrefix();

  var _useState = useState(defaultExpanded),
      _useState2 = _slicedToArray(_useState, 2),
      isExpanded = _useState2[0],
      setIsExpanded = _useState2[1];

  var _useState3 = useState(defaultExpanded),
      _useState4 = _slicedToArray(_useState3, 2),
      prevExpanded = _useState4[0],
      setPrevExpanded = _useState4[1];

  var className = cx((_cx = {}, _defineProperty(_cx, "".concat(prefix, "--side-nav__item"), true), _defineProperty(_cx, "".concat(prefix, "--side-nav__item--active"), isActive || hasActiveChild(children) && !isExpanded), _defineProperty(_cx, "".concat(prefix, "--side-nav__item--icon"), IconElement), _defineProperty(_cx, "".concat(prefix, "--side-nav__item--large"), large), _defineProperty(_cx, customClassName, !!customClassName), _cx));

  if (isSideNavExpanded === false && isExpanded === true) {
    setIsExpanded(false);
    setPrevExpanded(true);
  } else if (isSideNavExpanded === true && prevExpanded === true) {
    setIsExpanded(true);
    setPrevExpanded(false);
  }

  return (
    /*#__PURE__*/
    // eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions
    React.createElement("li", {
      className: className,
      onKeyDown: function onKeyDown(event) {
        if (match(event, keys.Escape)) {
          setIsExpanded(false);
        }
      }
    }, /*#__PURE__*/React.createElement("button", {
      "aria-expanded": isExpanded,
      className: "".concat(prefix, "--side-nav__submenu"),
      onClick: function onClick() {
        setIsExpanded(!isExpanded);
      },
      ref: ref,
      type: "button"
    }, IconElement && /*#__PURE__*/React.createElement(SideNavIcon, null, /*#__PURE__*/React.createElement(IconElement, null)), /*#__PURE__*/React.createElement("span", {
      className: "".concat(prefix, "--side-nav__submenu-title")
    }, title), /*#__PURE__*/React.createElement(SideNavIcon, {
      className: "".concat(prefix, "--side-nav__submenu-chevron"),
      small: true
    }, /*#__PURE__*/React.createElement(ChevronDown20, null))), /*#__PURE__*/React.createElement("ul", {
      className: "".concat(prefix, "--side-nav__menu")
    }, children))
  );
});
SideNavMenu.propTypes = {
  /**
   * Provide <SideNavMenuItem>'s inside of the `SideNavMenu`
   */
  children: PropTypes.node,

  /**
   * Provide an optional class to be applied to the containing node
   */
  className: PropTypes.string,

  /**
   * Specify whether the menu should default to expanded. By default, it will
   * be closed.
   */
  defaultExpanded: PropTypes.bool,

  /**
   * Specify whether the `SideNavMenu` is "active". `SideNavMenu` should be
   * considered active if one of its menu items are a link for the current
   * page.
   */
  isActive: PropTypes.bool,

  /**
   * Property to indicate if the side nav container is open (or not). Use to
   * keep local state and styling in step with the SideNav expansion state.
   */
  isSideNavExpanded: PropTypes.bool,

  /**
   * Specify if this is a large variation of the SideNavMenu
   */
  large: PropTypes.bool,

  /**
   * Pass in a custom icon to render next to the `SideNavMenu` title
   */
  renderIcon: PropTypes.oneOfType([PropTypes.func, PropTypes.object]),

  /**
   * Provide the text for the overall menu name
   */
  title: PropTypes.string.isRequired
};

function hasActiveChild(children) {
  // if we have children, either a single or multiple, find if it is active
  if (Array.isArray(children)) {
    return children.some(function (child) {
      if (!child.props) {
        return false;
      }

      if (child.props.isActive === true) {
        return true;
      }

      if (child.props['aria-current']) {
        return true;
      }

      return false;
    });
  }

  if (children.props) {
    if (children.props.isActive === true || children.props['aria-current']) {
      return true;
    }
  }

  return false;
}

export { SideNavMenu };