"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

require("carbon-components/scss/components/checkbox/_checkbox.scss");

var _react = _interopRequireDefault(require("react"));

var _react2 = require("@cypress/react");

var _Checkbox = _interopRequireDefault(require("../Checkbox"));

var _Checkbox2 = _interopRequireDefault(require("../Checkbox/Checkbox.Skeleton"));

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
describe('Checkbox', function () {
  beforeEach(function () {
    (0, _react2.mount)( /*#__PURE__*/_react.default.createElement("fieldset", {
      className: "fieldset"
    }, /*#__PURE__*/_react.default.createElement("legend", {
      className: "label"
    }, "Checkbox heading"), /*#__PURE__*/_react.default.createElement(_Checkbox.default, {
      labelText: "Checkbox label 1",
      id: "checkbox-label-1"
    }), /*#__PURE__*/_react.default.createElement(_Checkbox.default, {
      labelText: "Checkbox label 2",
      id: "checkbox-label-2"
    }), /*#__PURE__*/_react.default.createElement(_Checkbox2.default, null)));
  });
  it('should render unselected', function () {
    cy.findByText(/Checkbox label 1/).should('be.visible');
    cy.findByText(/Checkbox label 2/).should('be.visible'); // snapshots should always be taken _after_ an assertion that
    // a element/component should be visible. This is to ensure
    // the DOM has settled and the element has fully loaded.

    cy.percySnapshot();
  });
  it('should be selected and focused on click', function () {
    // must force the interaction because cypress detects the original
    // input hidden due to how we style the checkbox
    cy.findByLabelText('Checkbox label 1').click({
      force: true
    });
    cy.findByLabelText(/Checkbox label 1/).should('be.visible').and('have.focus').and('be.checked');
    cy.findByLabelText('Checkbox label 2').click({
      force: true
    });
    cy.findByLabelText(/Checkbox label 2/).should('be.visible').and('have.focus').and('be.checked'); // snapshots should always be taken _after_ an assertion that
    // a element/component should be visible. This is to ensure
    // the DOM has settled and the element has fully loaded.

    cy.percySnapshot();
  });
});