"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _downshift = _interopRequireDefault(require("downshift"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _Text = require("../Text");

var _iconsReact = require("@carbon/icons-react");

var _ListBox = _interopRequireWildcard(require("../ListBox"));

var _next = require("../ListBox/next");

var _keyboard = require("../../internal/keyboard");

var _setupGetInstanceId = _interopRequireDefault(require("../../tools/setupGetInstanceId"));

var _createPropAdapter = require("../../tools/createPropAdapter");

var _mergeRefs = _interopRequireDefault(require("../../tools/mergeRefs"));

var _FeatureFlags = require("../FeatureFlags");

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["ariaLabel", "className", "direction", "disabled", "downshiftProps", "helperText", "id", "initialSelectedItem", "invalid", "invalidText", "items", "itemToElement", "itemToString", "light", "onChange", "onInputChange", "onToggleClick", "placeholder", "selectedItem", "shouldFilterItem", "size", "titleText", "translateWithId", "type", "warn", "warnText"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var defaultItemToString = function defaultItemToString(item) {
  if (typeof item === 'string') {
    return item;
  }

  return item && item.label;
};

var defaultShouldFilterItem = function defaultShouldFilterItem() {
  return true;
};

var getInputValue = function getInputValue(_ref) {
  var initialSelectedItem = _ref.initialSelectedItem,
      inputValue = _ref.inputValue,
      itemToString = _ref.itemToString,
      selectedItem = _ref.selectedItem;

  if (selectedItem) {
    return itemToString(selectedItem);
  } // TODO: consistent `initialSelectedItem` behavior with other listbox components in v11


  if (initialSelectedItem) {
    return itemToString(initialSelectedItem);
  }

  return inputValue || '';
};

var findHighlightedIndex = function findHighlightedIndex(_ref2, inputValue) {
  var items = _ref2.items,
      itemToString = _ref2.itemToString;

  if (!inputValue) {
    return -1;
  }

  var searchValue = inputValue.toLowerCase();

  for (var i = 0; i < items.length; i++) {
    var item = itemToString(items[i]).toLowerCase();

    if (item.indexOf(searchValue) !== -1) {
      return i;
    }
  }

  return -1;
};

var getInstanceId = (0, _setupGetInstanceId.default)();

var ComboBox = /*#__PURE__*/_react.default.forwardRef(function (props, ref) {
  var _cx;

  var ariaLabel = props.ariaLabel,
      containerClassName = props.className,
      direction = props.direction,
      disabled = props.disabled,
      downshiftProps = props.downshiftProps,
      helperText = props.helperText,
      id = props.id,
      initialSelectedItem = props.initialSelectedItem,
      invalid = props.invalid,
      invalidText = props.invalidText,
      items = props.items,
      itemToElement = props.itemToElement,
      itemToString = props.itemToString,
      light = props.light,
      onChange = props.onChange,
      onInputChange = props.onInputChange,
      onToggleClick = props.onToggleClick,
      placeholder = props.placeholder,
      selectedItem = props.selectedItem,
      shouldFilterItem = props.shouldFilterItem,
      size = props.size,
      titleText = props.titleText,
      translateWithId = props.translateWithId,
      type = props.type,
      warn = props.warn,
      warnText = props.warnText,
      rest = (0, _objectWithoutProperties2.default)(props, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var textInput = (0, _react.useRef)();
  var comboBoxInstanceId = getInstanceId();

  var _useState = (0, _react.useState)(getInputValue({
    initialSelectedItem: initialSelectedItem,
    inputValue: '',
    itemToString: itemToString,
    selectedItem: selectedItem
  })),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      inputValue = _useState2[0],
      setInputValue = _useState2[1];

  var _useState3 = (0, _react.useState)(null),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      prevSelectedItem = _useState4[0],
      setPrevSelectedItem = _useState4[1];

  var _useState5 = (0, _react.useState)(null),
      _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
      doneInitialSelectedItem = _useState6[0],
      setDoneInitialSelectedItem = _useState6[1];

  var savedOnInputChange = (0, _react.useRef)(onInputChange);

  if (!doneInitialSelectedItem || prevSelectedItem !== selectedItem) {
    setDoneInitialSelectedItem(true);
    setPrevSelectedItem(selectedItem);
    setInputValue(getInputValue({
      initialSelectedItem: initialSelectedItem,
      inputValue: inputValue,
      itemToString: itemToString,
      selectedItem: selectedItem
    }));
  }

  var filterItems = function filterItems(items, itemToString, inputValue) {
    return items.filter(function (item) {
      return shouldFilterItem({
        item: item,
        itemToString: itemToString,
        inputValue: inputValue
      });
    });
  };

  var handleOnChange = function handleOnChange(selectedItem) {
    if (onChange) {
      onChange({
        selectedItem: selectedItem
      });
    }
  };

  var handleOnInputValueChange = function handleOnInputValueChange(inputValue) {
    setInputValue(inputValue || '');
  };

  (0, _react.useEffect)(function () {
    savedOnInputChange.current = onInputChange;
  }, [onInputChange]);
  (0, _react.useEffect)(function () {
    if (savedOnInputChange.current) {
      savedOnInputChange.current(inputValue);
    }
  }, [inputValue]);

  var handleSelectionClear = function handleSelectionClear() {
    if (textInput !== null && textInput !== void 0 && textInput.current) {
      textInput.current.focus();
    }
  };

  var handleOnStateChange = function handleOnStateChange(newState, _ref3) {
    var setHighlightedIndex = _ref3.setHighlightedIndex;

    if (Object.prototype.hasOwnProperty.call(newState, 'inputValue')) {
      var _inputValue = newState.inputValue;
      var filteredItems = filterItems(items, itemToString, _inputValue);
      setHighlightedIndex(findHighlightedIndex(_objectSpread(_objectSpread({}, props), {}, {
        items: filteredItems
      }), _inputValue));
    }
  };

  var handleToggleClick = function handleToggleClick(isOpen) {
    return function (event) {
      if (onToggleClick) {
        onToggleClick(event);
      }

      if (event.target === textInput.current && isOpen) {
        event.preventDownshiftDefault = true;
        event.persist();
      }
    };
  };

  var enabled = (0, _FeatureFlags.useFeatureFlag)('enable-v11-release');
  var showWarning = !invalid && warn;
  var className = (0, _classnames.default)("".concat(prefix, "--combo-box"), [enabled ? null : containerClassName], (_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--list-box--up"), direction === 'top'), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--combo-box--warning"), showWarning), _cx));
  var titleClasses = (0, _classnames.default)("".concat(prefix, "--label"), (0, _defineProperty2.default)({}, "".concat(prefix, "--label--disabled"), disabled));
  var comboBoxHelperId = !helperText ? undefined : "combobox-helper-text-".concat(comboBoxInstanceId);
  var helperClasses = (0, _classnames.default)("".concat(prefix, "--form__helper-text"), (0, _defineProperty2.default)({}, "".concat(prefix, "--form__helper-text--disabled"), disabled));
  var wrapperClasses = (0, _classnames.default)("".concat(prefix, "--list-box__wrapper"), [enabled ? containerClassName : null]);
  var inputClasses = (0, _classnames.default)("".concat(prefix, "--text-input"), (0, _defineProperty2.default)({}, "".concat(prefix, "--text-input--empty"), !inputValue)); // needs to be Capitalized for react to render it correctly

  var ItemToElement = itemToElement;
  return /*#__PURE__*/_react.default.createElement(_downshift.default, (0, _extends2.default)({}, (0, _createPropAdapter.mapDownshiftProps)(downshiftProps), {
    onChange: handleOnChange,
    onInputValueChange: handleOnInputValueChange,
    onStateChange: handleOnStateChange,
    inputValue: inputValue || '',
    itemToString: itemToString,
    initialSelectedItem: initialSelectedItem,
    inputId: id,
    selectedItem: selectedItem
  }), function (_ref4) {
    var _textInput$current;

    var getInputProps = _ref4.getInputProps,
        getItemProps = _ref4.getItemProps,
        getLabelProps = _ref4.getLabelProps,
        getMenuProps = _ref4.getMenuProps,
        getRootProps = _ref4.getRootProps,
        getToggleButtonProps = _ref4.getToggleButtonProps,
        isOpen = _ref4.isOpen,
        inputValue = _ref4.inputValue,
        selectedItem = _ref4.selectedItem,
        highlightedIndex = _ref4.highlightedIndex,
        clearSelection = _ref4.clearSelection,
        toggleMenu = _ref4.toggleMenu;
    var rootProps = getRootProps({}, {
      suppressRefError: true
    });
    var labelProps = getLabelProps();
    var buttonProps = getToggleButtonProps({
      disabled: disabled,
      onClick: handleToggleClick(isOpen),
      // When we moved the "root node" of Downshift to the <input> for
      // ARIA 1.2 compliance, we unfortunately hit this branch for the
      // "mouseup" event that downshift listens to:
      // https://github.com/downshift-js/downshift/blob/v5.2.1/src/downshift.js#L1051-L1065
      //
      // As a result, it will reset the state of the component and so we
      // stop the event from propagating to prevent this if the menu is already open.
      // This allows the toggleMenu behavior for the toggleButton to correctly open and
      // close the menu.
      onMouseUp: function onMouseUp(event) {
        if (isOpen) {
          event.stopPropagation();
        }
      }
    });
    var inputProps = getInputProps({
      // Remove excess aria `aria-labelledby`. HTML <label for> provides this aria information.
      'aria-labelledby': null,
      disabled: disabled,
      placeholder: placeholder,
      onClick: function onClick() {
        toggleMenu();
      },
      onKeyDown: function onKeyDown(event) {
        if ((0, _keyboard.match)(event, _keyboard.keys.Space)) {
          event.stopPropagation();
        }

        if ((0, _keyboard.match)(event, _keyboard.keys.Enter) && !inputValue) {
          toggleMenu();
        }
      }
    });
    return /*#__PURE__*/_react.default.createElement("div", {
      className: wrapperClasses
    }, titleText && /*#__PURE__*/_react.default.createElement(_Text.Text, (0, _extends2.default)({
      as: "label",
      className: titleClasses
    }, labelProps), titleText), /*#__PURE__*/_react.default.createElement(_ListBox.default, {
      className: className,
      disabled: disabled,
      invalid: invalid,
      invalidText: invalidText,
      isOpen: isOpen,
      light: light,
      size: size,
      warn: warn,
      warnText: warnText
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "".concat(prefix, "--list-box__field")
    }, /*#__PURE__*/_react.default.createElement("input", (0, _extends2.default)({
      role: "combobox",
      disabled: disabled,
      className: inputClasses,
      type: "text",
      tabIndex: "0",
      "aria-autocomplete": "list",
      "aria-expanded": rootProps['aria-expanded'],
      "aria-haspopup": "listbox",
      "aria-controls": inputProps['aria-controls'],
      title: textInput === null || textInput === void 0 ? void 0 : (_textInput$current = textInput.current) === null || _textInput$current === void 0 ? void 0 : _textInput$current.value
    }, inputProps, rest, {
      ref: (0, _mergeRefs.default)(textInput, ref)
    })), invalid && /*#__PURE__*/_react.default.createElement(_iconsReact.WarningFilled16, {
      className: "".concat(prefix, "--list-box__invalid-icon")
    }), showWarning && /*#__PURE__*/_react.default.createElement(_iconsReact.WarningAltFilled16, {
      className: "".concat(prefix, "--list-box__invalid-icon ").concat(prefix, "--list-box__invalid-icon--warning")
    }), inputValue && /*#__PURE__*/_react.default.createElement(_next.ListBoxSelection, {
      clearSelection: clearSelection,
      translateWithId: translateWithId,
      disabled: disabled,
      onClearSelection: handleSelectionClear
    }), /*#__PURE__*/_react.default.createElement(_next.ListBoxTrigger, (0, _extends2.default)({}, buttonProps, {
      isOpen: isOpen,
      translateWithId: translateWithId
    }))), /*#__PURE__*/_react.default.createElement(_ListBox.default.Menu, getMenuProps({
      'aria-label': ariaLabel
    }), isOpen ? filterItems(items, itemToString, inputValue).map(function (item, index) {
      var _getItemProps;

      var itemProps = getItemProps((_getItemProps = {
        item: item,
        index: index
      }, (0, _defineProperty2.default)(_getItemProps, 'aria-current', selectedItem === item ? true : null), (0, _defineProperty2.default)(_getItemProps, 'aria-selected', highlightedIndex === index ? true : null), (0, _defineProperty2.default)(_getItemProps, "disabled", item.disabled), _getItemProps));
      return /*#__PURE__*/_react.default.createElement(_ListBox.default.MenuItem, (0, _extends2.default)({
        key: itemProps.id,
        isActive: selectedItem === item,
        tabIndex: "-1",
        isHighlighted: highlightedIndex === index || (selectedItem === null || selectedItem === void 0 ? void 0 : selectedItem.id) && (selectedItem === null || selectedItem === void 0 ? void 0 : selectedItem.id) === item.id || false,
        title: itemToElement ? item.text : itemToString(item)
      }, itemProps), itemToElement ? /*#__PURE__*/_react.default.createElement(ItemToElement, (0, _extends2.default)({
        key: itemProps.id
      }, item)) : itemToString(item), selectedItem === item && /*#__PURE__*/_react.default.createElement(_iconsReact.Checkmark16, {
        className: "".concat(prefix, "--list-box__menu-item__selected-icon")
      }));
    }) : null)), helperText && !invalid && !warn && /*#__PURE__*/_react.default.createElement(_Text.Text, {
      as: "div",
      id: comboBoxHelperId,
      className: helperClasses
    }, helperText));
  });
});

ComboBox.displayName = 'ComboBox';
ComboBox.propTypes = {
  /**
   * 'aria-label' of the ListBox component.
   */
  ariaLabel: _propTypes.default.string,

  /**
   * An optional className to add to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify the direction of the combobox dropdown. Can be either top or bottom.
   */
  direction: _propTypes.default.oneOf(['top', 'bottom']),

  /**
   * Specify if the control should be disabled, or not
   */
  disabled: _propTypes.default.bool,

  /**
   * Additional props passed to Downshift
   */
  downshiftProps: _propTypes.default.shape(_downshift.default.propTypes),

  /**
   * Provide helper text that is used alongside the control label for
   * additional help
   */
  helperText: _propTypes.default.string,

  /**
   * Specify a custom `id` for the input
   */
  id: _propTypes.default.string.isRequired,

  /**
   * Allow users to pass in an arbitrary item or a string (in case their items are an array of strings)
   * from their collection that are pre-selected
   */
  initialSelectedItem: _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.string, _propTypes.default.number]),

  /**
   * Specify if the currently selected value is invalid.
   */
  invalid: _propTypes.default.bool,

  /**
   * Message which is displayed if the value is invalid.
   */
  invalidText: _propTypes.default.node,

  /**
   * Optional function to render items as custom components instead of strings.
   * Defaults to null and is overridden by a getter
   */
  itemToElement: _propTypes.default.func,

  /**
   * Helper function passed to downshift that allows the library to render a
   * given item to a string label. By default, it extracts the `label` field
   * from a given item to serve as the item label in the list
   */
  itemToString: _propTypes.default.func,

  /**
   * We try to stay as generic as possible here to allow individuals to pass
   * in a collection of whatever kind of data structure they prefer
   */
  items: _propTypes.default.array.isRequired,

  /**
   * should use "light theme" (white background)?
   */
  light: _propTypes.default.bool,

  /**
   * `onChange` is a utility for this controlled component to communicate to a
   * consuming component when a specific dropdown item is selected.
   * @param {{ selectedItem }}
   */
  onChange: _propTypes.default.func.isRequired,

  /**
   * Callback function to notify consumer when the text input changes.
   * This provides support to change available items based on the text.
   * @param {string} inputText
   */
  onInputChange: _propTypes.default.func,

  /**
   * Callback function that fires when the combobox menu toggle is clicked
   * @param {MouseEvent} event
   */
  onToggleClick: _propTypes.default.func,

  /**
   * Used to provide a placeholder text node before a user enters any input.
   * This is only present if the control has no items selected
   */
  placeholder: _propTypes.default.string.isRequired,

  /**
   * For full control of the selection
   */
  selectedItem: _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.string, _propTypes.default.number]),

  /**
   * Specify your own filtering logic by passing in a `shouldFilterItem`
   * function that takes in the current input and an item and passes back
   * whether or not the item should be filtered.
   */
  shouldFilterItem: _propTypes.default.func,

  /**
   * Specify the size of the ListBox. Currently supports either `sm`, `md` or `lg` as an option.
   */
  size: _ListBox.PropTypes.ListBoxSize,

  /**
   * Provide text to be used in a `<label>` element that is tied to the
   * combobox via ARIA attributes.
   */
  titleText: _propTypes.default.node,

  /**
   * Specify a custom translation function that takes in a message identifier
   * and returns the localized string for the message
   */
  translateWithId: _propTypes.default.func,

  /**
   * Currently supports either the default type, or an inline variant
   */
  type: _ListBox.PropTypes.ListBoxType,

  /**
   * Specify whether the control is currently in warning state
   */
  warn: _propTypes.default.bool,

  /**
   * Provide the text that is displayed when the control is in warning state
   */
  warnText: _propTypes.default.node
};
ComboBox.defaultProps = {
  disabled: false,
  itemToString: defaultItemToString,
  itemToElement: null,
  shouldFilterItem: defaultShouldFilterItem,
  type: 'default',
  ariaLabel: 'Choose an item',
  light: false,
  direction: 'bottom'
};
var _default = ComboBox;
exports.default = _default;