"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _react = _interopRequireDefault(require("react"));

var _enzyme = require("enzyme");

var _ComposedModal = _interopRequireDefault(require("./ComposedModal"));

var _ModalHeader = require("./ModalHeader");

var _ComposedModal2 = require("../ComposedModal");

var _carbonComponents = require("carbon-components");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var prefix = _carbonComponents.settings.prefix;
describe('<ComposedModal />', function () {
  var container;
  afterEach(function () {
    if (container && container.parentNode) {
      container.parentNode.removeChild(container);
    }

    container = null;
  });
  it('renders', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_ComposedModal.default, {
      open: true
    }));
    expect(wrapper).toMatchSnapshot();
  });
  it('changes the open state upon change in props', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_ComposedModal.default, {
      open: true
    }));
    expect(document.body.classList.contains('bx--body--with-modal-open')).toEqual(true);
    wrapper.setProps({
      open: false
    });
    expect(document.body.classList.contains('bx--body--with-modal-open')).toEqual(false);
  });
  it('should change class of <body> upon open state', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_ComposedModal.default, {
      open: true
    }));
    expect(document.body.classList.contains('bx--body--with-modal-open')).toEqual(true);
    wrapper.unmount();
    expect(document.body.classList.contains('bx--body--with-modal-open')).toEqual(false);
    (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_ComposedModal.default, {
      open: false
    }));
    expect(document.body.classList.contains('bx--body--with-modal-open')).toEqual(false);
  });
  it('calls onClick upon user-initiated closing', function () {
    var onClose = jest.fn();
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_ComposedModal.default, {
      open: true,
      onClose: onClose
    }, /*#__PURE__*/_react.default.createElement(_ModalHeader.ModalHeader, null)));
    var button = wrapper.find(".".concat(prefix, "--modal-close")).first();
    button.simulate('click');
    expect(document.body.classList.contains('bx--body--with-modal-open')).toEqual(false);
    expect(onClose.mock.calls.length).toBe(1);
  });
  it('provides a way to prevent upon user-initiated closing', function () {
    var onClose = jest.fn(function () {
      return false;
    });
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_ComposedModal.default, {
      open: true,
      onClose: onClose
    }, /*#__PURE__*/_react.default.createElement(_ModalHeader.ModalHeader, null)));
    var button = wrapper.find(".".concat(prefix, "--modal-close")).first();
    button.simulate('click');
    expect(document.body.classList.contains('bx--body--with-modal-open')).toEqual(true);
  });
  it('should focus on the primary actionable button in ModalFooter by default', function () {
    container = document.createElement('div');
    container.id = 'container';
    document.body.appendChild(container);
    (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_ComposedModal.default, {
      open: true
    }, /*#__PURE__*/_react.default.createElement(_ComposedModal2.ModalFooter, {
      primaryButtonText: "Save"
    })), {
      attachTo: document.querySelector('#container')
    });
    expect(document.activeElement.classList.contains("".concat(prefix, "--btn--primary"))).toEqual(true);
  });
  it('should focus on the element that matches selectorPrimaryFocus', function () {
    container = document.createElement('div');
    container.id = 'container';
    document.body.appendChild(container);
    (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_ComposedModal.default, {
      open: true,
      selectorPrimaryFocus: ".".concat(prefix, "--modal-close")
    }, /*#__PURE__*/_react.default.createElement(_ModalHeader.ModalHeader, {
      label: "Optional Label",
      title: "Example"
    }), /*#__PURE__*/_react.default.createElement(_ComposedModal2.ModalFooter, {
      primaryButtonText: "Save"
    })), {
      attachTo: document.querySelector('#container')
    });
    expect(document.activeElement.classList.contains("".concat(prefix, "--modal-close"))).toEqual(true);
  });
});