"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _FeatureFlags = require("../FeatureFlags");

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["as", "condensed", "narrow", "fullWidth", "columns", "className", "children"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var SubgridContext = /*#__PURE__*/_react.default.createContext(false);

function Grid(_ref) {
  var _cssGridClassNames, _flexGridClassNames;

  var _ref$as = _ref.as,
      BaseComponent = _ref$as === void 0 ? 'div' : _ref$as,
      _ref$condensed = _ref.condensed,
      condensed = _ref$condensed === void 0 ? false : _ref$condensed,
      _ref$narrow = _ref.narrow,
      narrow = _ref$narrow === void 0 ? false : _ref$narrow,
      _ref$fullWidth = _ref.fullWidth,
      fullWidth = _ref$fullWidth === void 0 ? false : _ref$fullWidth,
      _ref$columns = _ref.columns,
      columns = _ref$columns === void 0 ? 16 : _ref$columns,
      containerClassName = _ref.className,
      children = _ref.children,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var hasCSSGrid = (0, _FeatureFlags.useFeatureFlag)('enable-css-grid');
  var isSubgrid = (0, _react.useContext)(SubgridContext);
  var cssGridClassNames = (_cssGridClassNames = {}, (0, _defineProperty2.default)(_cssGridClassNames, "".concat(prefix, "--css-grid"), !isSubgrid), (0, _defineProperty2.default)(_cssGridClassNames, "".concat(prefix, "--css-grid--").concat(columns), !isSubgrid && columns !== 16), (0, _defineProperty2.default)(_cssGridClassNames, "".concat(prefix, "--css-grid--condensed"), condensed), (0, _defineProperty2.default)(_cssGridClassNames, "".concat(prefix, "--css-grid--narrow"), narrow), (0, _defineProperty2.default)(_cssGridClassNames, "".concat(prefix, "--css-grid--full-width"), fullWidth), (0, _defineProperty2.default)(_cssGridClassNames, "".concat(prefix, "--subgrid"), isSubgrid), (0, _defineProperty2.default)(_cssGridClassNames, "".concat(prefix, "--col-span-").concat(columns), isSubgrid && columns !== 16 || columns !== 16), _cssGridClassNames);
  var flexGridClassNames = (_flexGridClassNames = {}, (0, _defineProperty2.default)(_flexGridClassNames, "".concat(prefix, "--grid"), true), (0, _defineProperty2.default)(_flexGridClassNames, "".concat(prefix, "--grid--condensed"), condensed), (0, _defineProperty2.default)(_flexGridClassNames, "".concat(prefix, "--grid--narrow"), narrow), (0, _defineProperty2.default)(_flexGridClassNames, "".concat(prefix, "--grid--full-width"), fullWidth), _flexGridClassNames);
  var className = (0, _classnames.default)(containerClassName, hasCSSGrid ? cssGridClassNames : flexGridClassNames);
  return /*#__PURE__*/_react.default.createElement(SubgridContext.Provider, {
    value: true
  }, /*#__PURE__*/_react.default.createElement(BaseComponent, (0, _extends2.default)({
    className: className
  }, rest), children));
}

Grid.propTypes = {
  /**
   * Provide a custom element to render instead of the default <div>
   */
  as: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.elementType]),

  /**
   * Pass in content that will be rendered within the `Grid`
   */
  children: _propTypes.default.node,

  /**
   * Specify a custom className to be applied to the `Grid`
   */
  className: _propTypes.default.string,

  /**
   * Specify how many columns wide the Grid should span
   */
  columns: _propTypes.default.number,

  /**
   * Collapse the gutter to 1px. Useful for fluid layouts.
   * Rows have 1px of margin between them to match gutter.
   */
  condensed: _propTypes.default.bool,

  /**
   * Remove the default max width that the grid has set
   */
  fullWidth: _propTypes.default.bool,

  /**
   * Container hangs 16px into the gutter. Useful for
   * typographic alignment with and without containers.
   */
  narrow: _propTypes.default.bool
};
var _default = Grid;
exports.default = _default;