"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = InlineLoading;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _iconsReact = require("@carbon/icons-react");

var _deprecate = _interopRequireDefault(require("../../prop-types/deprecate"));

var _Loading = _interopRequireDefault(require("../Loading"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["className", "success", "status", "iconDescription", "description", "onSuccess", "successDelay"];

function InlineLoading(_ref) {
  var className = _ref.className,
      success = _ref.success,
      _ref$status = _ref.status,
      status = _ref$status === void 0 ? success ? 'finished' : 'active' : _ref$status,
      iconDescription = _ref.iconDescription,
      description = _ref.description,
      onSuccess = _ref.onSuccess,
      successDelay = _ref.successDelay,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var loadingClasses = (0, _classnames.default)("".concat(prefix, "--inline-loading"), className);

  var getLoading = function getLoading() {
    if (status === 'error') {
      return /*#__PURE__*/_react.default.createElement(_iconsReact.ErrorFilled16, {
        className: "".concat(prefix, "--inline-loading--error")
      }, /*#__PURE__*/_react.default.createElement("title", null, iconDescription));
    }

    if (status === 'finished') {
      setTimeout(function () {
        if (onSuccess) {
          onSuccess();
        }
      }, successDelay);
      return /*#__PURE__*/_react.default.createElement(_iconsReact.CheckmarkFilled16, {
        className: "".concat(prefix, "--inline-loading__checkmark-container")
      }, /*#__PURE__*/_react.default.createElement("title", null, iconDescription));
    }

    if (status === 'inactive' || status === 'active') {
      return /*#__PURE__*/_react.default.createElement(_Loading.default, {
        small: true,
        description: iconDescription,
        withOverlay: false,
        active: status === 'active'
      });
    }

    return undefined;
  };

  var loadingText = /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--inline-loading__text")
  }, description);

  var loading = getLoading();

  var loadingAnimation = loading && /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--inline-loading__animation")
  }, loading);

  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: loadingClasses
  }, other, {
    "aria-live": 'assertive' || other['aria-live']
  }), loadingAnimation, description && loadingText);
}

InlineLoading.propTypes = {
  /**
   * Specify a custom className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify the description for the inline loading text
   */
  description: _propTypes.default.node,

  /**
   * Specify the description for the inline loading text
   */
  iconDescription: _propTypes.default.string,

  /**
   * Provide an optional handler to be invoked when <InlineLoading> is
   * successful
   */
  onSuccess: _propTypes.default.func,

  /**
   * Specify the loading status
   */
  status: _propTypes.default.oneOf(['inactive', 'active', 'finished', 'error']),

  /**
   * Specify whether the load was successful
   */
  success: (0, _deprecate.default)(_propTypes.default.bool, "\nThe prop `success` for InlineLoading has been deprecated in favor of `status`. Please use `status=\"finished\"` instead."),

  /**
   * Provide a delay for the `setTimeout` for success
   */
  successDelay: _propTypes.default.number
};
InlineLoading.defaultProps = {
  successDelay: 1500
};