"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _MenuOption = _interopRequireDefault(require("./MenuOption"));

var _excluded = ["label", "children", "disabled", "kind", "shortcut"];

function MenuItem(_ref) {
  var label = _ref.label,
      children = _ref.children,
      disabled = _ref.disabled,
      kind = _ref.kind,
      shortcut = _ref.shortcut,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return /*#__PURE__*/_react.default.createElement(_MenuOption.default, (0, _extends2.default)({}, rest, {
    label: label,
    disabled: disabled,
    kind: kind,
    shortcut: shortcut
  }), children);
}

MenuItem.propTypes = {
  /**
   * Specify the children of the MenuItem
   */
  children: _propTypes.default.node,

  /**
   * Specify whether this MenuItem is disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Optional prop to specify the kind of the MenuItem
   */
  kind: _propTypes.default.oneOf(['default', 'danger']),

  /**
   * Rendered label for the MenuItem
   */
  label: _propTypes.default.node.isRequired,

  /**
   * Rendered shortcut for the MenuItem
   */
  shortcut: _propTypes.default.node
};
var _default = MenuItem;
exports.default = _default;