"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WithChangeOnClose = exports._Filterable = exports.WithInitialSelectedItems = exports.ItemToElement = exports.controlled = exports.Default = exports.default = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _storybookReadme = require("storybook-readme");

var _README = _interopRequireDefault(require("./README.md"));

var _MultiSelect = _interopRequireDefault(require("../MultiSelect"));

var _FilterableMultiSelect = _interopRequireDefault(require("../MultiSelect/FilterableMultiSelect"));

var _Checkbox = _interopRequireDefault(require("../Checkbox"));

var _MultiSelect2 = _interopRequireDefault(require("./MultiSelect.mdx"));

var _Button = _interopRequireDefault(require("../Button"));

var _excluded = ["listBoxMenuIconTranslationIds", "selectionFeedback"],
    _excluded2 = ["listBoxMenuIconTranslationIds", "selectionFeedback"],
    _excluded3 = ["listBoxMenuIconTranslationIds", "selectionFeedback"],
    _excluded4 = ["listBoxMenuIconTranslationIds", "selectionFeedback"],
    _excluded5 = ["listBoxMenuIconTranslationIds", "selectionFeedback"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var items = [{
  id: 'downshift-1-item-0',
  text: 'Option 1'
}, {
  id: 'downshift-1-item-1',
  text: 'Option 2'
}, {
  id: 'downshift-1-item-2',
  text: 'Option 3 - a disabled item',
  disabled: true
}, {
  id: 'downshift-1-item-3',
  text: 'Option 4'
}, {
  id: 'downshift-1-item-4',
  text: 'An example option that is really long to show what should be done to handle long text'
}, {
  id: 'downshift-1-item-5',
  text: 'Option 5'
}];
var defaultLabel = 'MultiSelect Label';
var defaultPlaceholder = 'Filter';
var types = {
  'Default (default)': 'default',
  'Inline (inline)': 'inline'
};
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};
var directions = {
  'Bottom (default)': 'bottom',
  'Top ': 'top'
};

var props = function props() {
  return {
    id: (0, _addonKnobs.text)('MultiSelect ID (id)', 'carbon-multiselect-example'),
    titleText: (0, _addonKnobs.text)('Title (titleText)', 'Multiselect title'),
    hideLabel: (0, _addonKnobs.boolean)('No title text shown (hideLabel)', false),
    helperText: (0, _addonKnobs.text)('Helper text (helperText)', 'This is helper text'),
    disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
    light: (0, _addonKnobs.boolean)('Light variant (light)', false),
    useTitleInItem: (0, _addonKnobs.boolean)('Show tooltip on hover', false),
    type: (0, _addonKnobs.select)('UI type (Only for `<MultiSelect>`) (type)', types, 'default'),
    size: (0, _addonKnobs.select)('Field size (size)', sizes, undefined) || undefined,
    direction: (0, _addonKnobs.select)('Dropdown direction (direction)', directions, 'bottom'),
    label: (0, _addonKnobs.text)('Label (label)', defaultLabel),
    invalid: (0, _addonKnobs.boolean)('Show form validation UI (invalid)', false),
    invalidText: (0, _addonKnobs.text)('Form validation UI content (invalidText)', 'Invalid Selection'),
    warn: (0, _addonKnobs.boolean)('Show warning state (warn)', false),
    warnText: (0, _addonKnobs.text)('Warning state text (warnText)', 'Selecting more items may increase processing time'),
    onChange: (0, _addonActions.action)('onChange'),
    onMenuChange: (0, _addonActions.action)('onMenuChange'),
    listBoxMenuIconTranslationIds: (0, _addonKnobs.object)('Listbox menu icon translation IDs (for translateWithId callback)', {
      'close.menu': 'Close menu',
      'open.menu': 'Open menu',
      'clear.all': 'Clear all',
      'clear.selection': 'Clear selection'
    }),
    selectionFeedback: (0, _addonKnobs.select)('Selection feedback', ['top', 'fixed', 'top-after-reopen'], 'top-after-reopen')
  };
};

var _default = {
  title: 'Components/MultiSelect',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _MultiSelect.default,
    docs: {
      page: _MultiSelect2.default
    },
    subcomponents: {
      FilterableMultiSelect: _FilterableMultiSelect.default
    }
  }
};
exports.default = _default;
var Default = (0, _storybookReadme.withReadme)(_README.default, function () {
  var _props = props(),
      listBoxMenuIconTranslationIds = _props.listBoxMenuIconTranslationIds,
      selectionFeedback = _props.selectionFeedback,
      multiSelectProps = (0, _objectWithoutProperties2.default)(_props, _excluded);

  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_MultiSelect.default, (0, _extends2.default)({}, multiSelectProps, {
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    translateWithId: function translateWithId(id) {
      return listBoxMenuIconTranslationIds[id];
    },
    selectionFeedback: selectionFeedback
  })));
});
exports.Default = Default;
var controlled = (0, _storybookReadme.withReadme)(_README.default, function () {
  var _props2 = props(),
      listBoxMenuIconTranslationIds = _props2.listBoxMenuIconTranslationIds,
      selectionFeedback = _props2.selectionFeedback,
      multiSelectProps = (0, _objectWithoutProperties2.default)(_props2, _excluded2);

  var _useState = (0, _react.useState)([]),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      selectedItems = _useState2[0],
      setSelectedItems = _useState2[1];

  var onChange = (0, _react.useCallback)(function (_ref) {
    var newSelectedItems = _ref.selectedItems;
    setSelectedItems(newSelectedItems);
  }, []);
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_MultiSelect.default, (0, _extends2.default)({}, multiSelectProps, {
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    translateWithId: function translateWithId(id) {
      return listBoxMenuIconTranslationIds[id];
    },
    selectionFeedback: selectionFeedback,
    onChange: onChange,
    selectedItems: selectedItems
  })), /*#__PURE__*/_react.default.createElement(_Button.default, {
    onClick: function onClick() {
      setSelectedItems([{
        id: 'downshift-1-item-0',
        text: 'Option 1'
      }]);
    }
  }, "click to select only Option 1"), /*#__PURE__*/_react.default.createElement(_Button.default, {
    onClick: function onClick() {
      setSelectedItems([]);
    }
  }, "click to clear selections"));
});
exports.controlled = controlled;
var ItemToElement = (0, _storybookReadme.withReadme)(_README.default, function () {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_MultiSelect.default, {
    titleText: "Multiselect with element items",
    label: "Choose an item",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    itemToElement: function itemToElement(item) {
      return item ? /*#__PURE__*/_react.default.createElement("span", {
        className: "test"
      }, item.text, ' ', /*#__PURE__*/_react.default.createElement("span", {
        role: "img",
        alt: "fire"
      }, ' ', "\uD83D\uDD25")) : '';
    }
  }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_FilterableMultiSelect.default, {
    titleText: "Filterable Multiselect with element items",
    placeholder: "itemToElement example",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    itemToElement: function itemToElement(item) {
      return item ? /*#__PURE__*/_react.default.createElement("span", {
        className: "test"
      }, item.text, ' ', /*#__PURE__*/_react.default.createElement("span", {
        role: "img",
        alt: "fire"
      }, ' ', "\uD83D\uDD25")) : '';
    }
  }));
});
exports.ItemToElement = ItemToElement;
Default.storyName = 'default';
Default.parameters = {
  info: {
    text: "\n        MultiSelect\n      "
  }
};
var WithInitialSelectedItems = (0, _storybookReadme.withReadme)(_README.default, function () {
  var _props3 = props(),
      listBoxMenuIconTranslationIds = _props3.listBoxMenuIconTranslationIds,
      selectionFeedback = _props3.selectionFeedback,
      multiSelectProps = (0, _objectWithoutProperties2.default)(_props3, _excluded3);

  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_MultiSelect.default, (0, _extends2.default)({}, multiSelectProps, {
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    initialSelectedItems: [items[0], items[1]],
    translateWithId: function translateWithId(id) {
      return listBoxMenuIconTranslationIds[id];
    },
    selectionFeedback: selectionFeedback
  })));
});
exports.WithInitialSelectedItems = WithInitialSelectedItems;
WithInitialSelectedItems.storyName = 'with initial selected items';
WithInitialSelectedItems.parameters = {
  info: {
    text: "\n        Provide a set of items to initially select in the control\n      "
  }
};

var _Filterable = (0, _storybookReadme.withReadme)(_README.default, function () {
  var _props4 = props(),
      listBoxMenuIconTranslationIds = _props4.listBoxMenuIconTranslationIds,
      selectionFeedback = _props4.selectionFeedback,
      multiSelectProps = (0, _objectWithoutProperties2.default)(_props4, _excluded4);

  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_FilterableMultiSelect.default, (0, _extends2.default)({}, multiSelectProps, {
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    placeholder: defaultPlaceholder,
    translateWithId: function translateWithId(id) {
      return listBoxMenuIconTranslationIds[id];
    },
    selectionFeedback: selectionFeedback,
    onMenuChange: function onMenuChange(e) {
      multiSelectProps.onMenuChange(e);
    }
  })));
});

exports._Filterable = _Filterable;
_Filterable.storyName = 'filterable';
_Filterable.parameters = {
  info: {
    text: "\n        When a list contains more than 25 items, use `MultiSelect.Filterable` to help find options from the list.\n      "
  }
};
var WithChangeOnClose = (0, _storybookReadme.withReadme)(_README.default, function () {
  var _props5 = props(),
      listBoxMenuIconTranslationIds = _props5.listBoxMenuIconTranslationIds,
      selectionFeedback = _props5.selectionFeedback,
      multiSelectProps = (0, _objectWithoutProperties2.default)(_props5, _excluded5);

  var _useState3 = (0, _react.useState)(false),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      hasFocus = _useState4[0],
      setHasFocus = _useState4[1];

  var _useState5 = (0, _react.useState)(false),
      _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
      active = _useState6[0],
      setActive = _useState6[1];

  var _useState7 = (0, _react.useState)([items[0]]),
      _useState8 = (0, _slicedToArray2.default)(_useState7, 2),
      selItems = _useState8[0],
      setSelItems = _useState8[1];

  if (!hasFocus && active && selItems.length == 0) {
    setActive(false);
  }

  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_Checkbox.default, {
    id: "active",
    checked: active,
    onChange: function onChange(a) {
      setActive(a);

      if (a) {
        setSelItems([items[0]]);
      }
    },
    labelText: "Active"
  }), /*#__PURE__*/_react.default.createElement(_MultiSelect.default, (0, _extends2.default)({}, multiSelectProps, {
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    translateWithId: function translateWithId(id) {
      return listBoxMenuIconTranslationIds[id];
    },
    selectionFeedback: selectionFeedback,
    key: active,
    disabled: !active,
    initialSelectedItems: selItems,
    onMenuChange: function onMenuChange(e) {
      multiSelectProps.onMenuChange(e);
      setHasFocus(e);
    },
    onChange: function onChange(e) {
      setSelItems(e.selectedItems);
    }
  })));
});
exports.WithChangeOnClose = WithChangeOnClose;