"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _setupGetInstanceId = _interopRequireDefault(require("../../../tools/setupGetInstanceId"));

var _Select = _interopRequireDefault(require("../../Select"));

var _SelectItem = _interopRequireDefault(require("../../SelectItem"));

var _excluded = ["className", "currentPage", "id", "labelText", "totalPages"];
var prefix = _carbonComponents.settings.prefix;
var getInstanceId = (0, _setupGetInstanceId.default)();

function PageSelector(_ref) {
  var className = _ref.className,
      currentPage = _ref.currentPage,
      id = _ref.id,
      labelText = _ref.labelText,
      totalPages = _ref.totalPages,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var namespace = "".concat(prefix, "--unstable-pagination__page-selector");
  var instanceId = "".concat(namespace, "__select-").concat(getInstanceId());

  var renderPages = function renderPages(total) {
    var pages = [];

    for (var counter = 1; counter <= total; counter += 1) {
      pages.push( /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
        key: counter,
        value: counter,
        text: String(counter)
      }));
    }

    return pages;
  };

  return /*#__PURE__*/_react.default.createElement(_Select.default, (0, _extends2.default)({
    className: (0, _classnames.default)(namespace, className),
    hideLabel: true,
    id: instanceId || id,
    inline: true,
    labelText: labelText,
    value: currentPage
  }, other), renderPages(totalPages));
}

PageSelector.propTypes = {
  /** Extra class names to add. */
  className: _propTypes.default.string,

  /** The current page. */
  currentPage: _propTypes.default.number.isRequired,

  /** The unique ID of this component instance. */
  id: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),

  /** Translatable string to label the page selector element. */
  labelText: _propTypes.default.string,

  /**
   * Total number of pages.
   * This value is calculated using a valid `totalItems` prop passed to the parent `Unstable_Pagination`.
   */
  totalPages: _propTypes.default.number.isRequired
};
PageSelector.defaultProps = {
  className: null,
  id: 1,
  labelText: 'Current page number'
};
var _default = PageSelector;
exports.default = _default;