"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Example = exports.Indeterminate = exports._ProgressBar = exports.default = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react = _interopRequireWildcard(require("react"));

var _ = _interopRequireDefault(require("../"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Copyright IBM Corp. 2021
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var _default = {
  title: 'Experimental/unstable_ProgressBar',
  parameters: {
    component: _.default
  }
};
exports.default = _default;

var _ProgressBar = function _ProgressBar() {
  return /*#__PURE__*/_react.default.createElement(_.default, {
    label: "Progress bar label",
    helperText: "Optional helper text",
    value: 75
  });
};

exports._ProgressBar = _ProgressBar;

var Indeterminate = function Indeterminate() {
  return /*#__PURE__*/_react.default.createElement(_.default, {
    label: "Progress bar label",
    helperText: "Optional helper text"
  });
};

exports.Indeterminate = Indeterminate;

var Example = function Example() {
  var size = 728;

  var _useState = (0, _react.useState)(0),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      progress = _useState2[0],
      setProgress = _useState2[1];

  (0, _react.useEffect)(function () {
    setTimeout(function () {
      var interval = setInterval(function () {
        setProgress(function (currentProgress) {
          var advancement = Math.random() * 8;

          if (currentProgress + advancement < size) {
            return currentProgress + advancement;
          } else {
            clearInterval(interval);
            return size;
          }
        });
      }, 50);
    }, 3000);
  }, []);
  var running = progress > 0;
  var helperText = running ? "".concat(progress.toFixed(1), "MB of ").concat(size, "MB") : 'Fetching assets...';

  if (progress >= size) {
    helperText = 'Done';
  }

  return /*#__PURE__*/_react.default.createElement(_.default, {
    value: running ? progress : null,
    max: size,
    label: "Export data",
    helperText: helperText
  });
};

exports.Example = Example;