"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _iconsReact = require("@carbon/icons-react");

var _carbonComponents = require("carbon-components");

var _events = require("../../tools/events");

var _keyboard = require("../../internal/keyboard");

var _deprecate = _interopRequireDefault(require("../../prop-types/deprecate"));

var _FeatureFlags = require("../FeatureFlags");

var _excluded = ["className", "type", "id", "placeHolderText", "placeholder", "labelText", "closeButtonLabelText", "small", "size", "light", "disabled", "onChange", "onKeyDown", "renderIcon", "onClear"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var prefix = _carbonComponents.settings.prefix;

var Search = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(Search, _Component);

  var _super = _createSuper(Search);

  function Search() {
    var _this;

    (0, _classCallCheck2.default)(this, Search);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      hasContent: _this.props.value || _this.props.defaultValue || false,
      prevValue: _this.props.value
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "clearInput", function (evt) {
      if (!_this.props.value) {
        _this.input.value = '';

        _this.props.onChange(evt);
      } else {
        var clearedEvt = Object.assign({}, evt.target, {
          target: {
            value: ''
          }
        });

        _this.props.onChange(clearedEvt);
      }

      _this.props.onClear();

      _this.setState({
        hasContent: false
      }, function () {
        return _this.input.focus();
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleChange", function (evt) {
      _this.setState({
        hasContent: evt.target.value !== ''
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleKeyDown", function (evt) {
      if ((0, _keyboard.match)(evt, _keyboard.keys.Escape)) {
        _this.clearInput(evt);
      }
    });
    return _this;
  }

  (0, _createClass2.default)(Search, [{
    key: "render",
    value: function render() {
      var _classNames,
          _classNames2,
          _this2 = this;

      var _this$props = this.props,
          className = _this$props.className,
          type = _this$props.type,
          _this$props$id = _this$props.id,
          id = _this$props$id === void 0 ? this._inputId = this._inputId || "search__input__id_".concat(Math.random().toString(36).substr(2)) : _this$props$id,
          placeHolderText = _this$props.placeHolderText,
          placeholder = _this$props.placeholder,
          labelText = _this$props.labelText,
          closeButtonLabelText = _this$props.closeButtonLabelText,
          small = _this$props.small,
          _this$props$size = _this$props.size,
          size = _this$props$size === void 0 ? !small ? 'xl' : 'sm' : _this$props$size,
          light = _this$props.light,
          disabled = _this$props.disabled,
          onChange = _this$props.onChange,
          onKeyDown = _this$props.onKeyDown,
          renderIcon = _this$props.renderIcon,
          onClear = _this$props.onClear,
          other = (0, _objectWithoutProperties2.default)(_this$props, _excluded);
      var hasContent = this.state.hasContent;
      var scope = this.context;
      var enabled;

      if (scope.enabled) {
        enabled = scope.enabled('enable-v11-release');
      }

      var searchClasses = (0, _classnames.default)((_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--search"), true), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--search--sm"), size === 'sm'), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--search--lg"), enabled ? size === 'md' : size === 'lg'), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--search--xl"), enabled ? size === 'lg' : size === 'xl'), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--search--light"), light), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--search--disabled"), disabled), (0, _defineProperty2.default)(_classNames, className, className), _classNames));
      var clearClasses = (0, _classnames.default)((_classNames2 = {}, (0, _defineProperty2.default)(_classNames2, "".concat(prefix, "--search-close"), true), (0, _defineProperty2.default)(_classNames2, "".concat(prefix, "--search-close--hidden"), !hasContent), _classNames2));
      var customIcon;

      if (renderIcon) {
        customIcon = /*#__PURE__*/_react.default.cloneElement(renderIcon, {
          className: "".concat(prefix, "--search-magnifier-icon")
        });
      }

      var searchId = "".concat(id, "-search");
      var searchIcon = renderIcon ? customIcon : /*#__PURE__*/_react.default.createElement(_iconsReact.Search16, {
        className: "".concat(prefix, "--search-magnifier-icon")
      });
      return /*#__PURE__*/_react.default.createElement("div", {
        role: "search",
        "aria-labelledby": searchId,
        className: searchClasses
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "".concat(prefix, "--search-magnifier"),
        ref: function ref(magnifier) {
          _this2.magnifier = magnifier;
        }
      }, searchIcon), /*#__PURE__*/_react.default.createElement("label", {
        id: searchId,
        htmlFor: id,
        className: "".concat(prefix, "--label")
      }, labelText), /*#__PURE__*/_react.default.createElement("input", (0, _extends2.default)({
        role: "searchbox",
        autoComplete: "off"
      }, other, {
        type: type,
        disabled: disabled,
        className: "".concat(prefix, "--search-input"),
        id: id,
        placeholder: placeHolderText || placeholder,
        onChange: (0, _events.composeEventHandlers)([onChange, this.handleChange]),
        onKeyDown: (0, _events.composeEventHandlers)([onKeyDown, this.handleKeyDown]),
        ref: function ref(input) {
          _this2.input = input;
        }
      })), /*#__PURE__*/_react.default.createElement("button", {
        className: clearClasses,
        disabled: disabled,
        onClick: this.clearInput,
        type: "button",
        "aria-label": closeButtonLabelText
      }, /*#__PURE__*/_react.default.createElement(_iconsReact.Close16, null)));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref, state) {
      var value = _ref.value;
      var prevValue = state.prevValue;
      return prevValue === value ? null : {
        hasContent: !!value,
        prevValue: value
      };
    }
  }]);
  return Search;
}(_react.Component);

exports.default = Search;
(0, _defineProperty2.default)(Search, "propTypes", {
  /**
   * Specify an optional className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify a label to be read by screen readers on the "close" button
   */
  closeButtonLabelText: _propTypes.default.string,

  /**
   * Optionally provide the default value of the `<input>`
   */
  defaultValue: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),

  /**
   * Specify whether the `<input>` should be disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Specify a custom `id` for the input
   */
  id: _propTypes.default.string,

  /**
   * Provide the label text for the Search icon
   */
  labelText: _propTypes.default.node.isRequired,

  /**
   * Specify light version or default version of this control
   */
  light: _propTypes.default.bool,

  /**
   * Optional callback called when the search value changes.
   */
  onChange: _propTypes.default.func,

  /**
   * Optional callback called when the search value is cleared.
   */
  onClear: _propTypes.default.func,

  /**
   * Provide a handler that is invoked on the key down event for the input
   */
  onKeyDown: _propTypes.default.func,

  /**
   * Deprecated in favor of `placeholder`
   */
  placeHolderText: (0, _deprecate.default)(_propTypes.default.string, "\nThe prop `placeHolderText` for Search has been deprecated in favor of `placeholder`. Please use `placeholder` instead."),

  /**
   * Provide an optional placeholder text for the Search.
   * Note: if the label and placeholder differ,
   * VoiceOver on Mac will read both
   */
  placeholder: _propTypes.default.string,

  /**
   * Rendered icon for the Search.
   * Can be a React component class
   */
  renderIcon: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object]),

  /**
   * Specify the search size
   */
  size: _propTypes.default.oneOf(['sm', 'md', 'lg', 'xl']),

  /**
   * Specify whether the Search should be a small variant
   */

  /**
   * Specify whether the load was successful
   */
  small: (0, _deprecate.default)(_propTypes.default.bool, "\nThe prop `small` for Search has been deprecated in favor of `size`. Please use `size=\"sm\"` instead."),

  /**
   * Optional prop to specify the type of the `<input>`
   */
  type: _propTypes.default.string,

  /**
   * Specify the value of the `<input>`
   */
  value: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number])
});
(0, _defineProperty2.default)(Search, "contextType", _FeatureFlags.FeatureFlagContext);
(0, _defineProperty2.default)(Search, "defaultProps", {
  type: 'text',
  placeholder: '',
  closeButtonLabelText: 'Clear search input',
  onChange: function onChange() {},
  onClear: function onClear() {}
});