"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _lodash = _interopRequireDefault(require("lodash.throttle"));

var FeatureFlags = _interopRequireWildcard(require("@carbon/feature-flags"));

var keys = _interopRequireWildcard(require("../../internal/keyboard/keys"));

var _match = require("../../internal/keyboard/match");

var _deprecate = _interopRequireDefault(require("../../prop-types/deprecate"));

var _FeatureFlags = require("../FeatureFlags");

var _excluded = ["ariaLabelInput", "className", "hideTextInput", "id", "min", "minLabel", "max", "maxLabel", "formatLabel", "labelText", "step", "stepMuliplier", "stepMultiplier", "inputType", "required", "disabled", "name", "light"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var prefix = _carbonComponents.settings.prefix;

var defaultFormatLabel = function defaultFormatLabel(value, label) {
  return typeof label === 'function' ? label(value) : "".concat(value).concat(label);
};
/**
 * Minimum time between processed "drag" events.
 */


var EVENT_THROTTLE = 16; // ms

/**
 * Event types that trigger "drags".
 */

var DRAG_EVENT_TYPES = new Set(['mousemove', 'touchmove']);
/**
 * Event types that trigger a "drag" to stop.
 */

var DRAG_STOP_EVENT_TYPES = new Set(['mouseup', 'touchend', 'touchcancel']);

var Slider = /*#__PURE__*/function (_PureComponent) {
  (0, _inherits2.default)(Slider, _PureComponent);

  var _super = _createSuper(Slider);

  function Slider() {
    var _this;

    (0, _classCallCheck2.default)(this, Slider);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      value: _this.props.value,
      left: 0,
      needsOnRelease: false,
      isValid: true
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onDragStart", function (evt) {
      // Do nothing if component is disabled
      if (_this.props.disabled) {
        return;
      } // Register drag stop handlers


      DRAG_STOP_EVENT_TYPES.forEach(function (element) {
        _this.element.ownerDocument.addEventListener(element, _this.onDragStop);
      }); // Register drag handlers

      DRAG_EVENT_TYPES.forEach(function (element) {
        _this.element.ownerDocument.addEventListener(element, _this.onDrag);
      }); // Perform first recalculation since we probably didn't click exactly in the
      // middle of the thumb

      _this.onDrag(evt);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onDragStop", function () {
      // Do nothing if component is disabled
      if (_this.props.disabled) {
        return;
      } // Remove drag stop handlers


      DRAG_STOP_EVENT_TYPES.forEach(function (element) {
        _this.element.ownerDocument.removeEventListener(element, _this.onDragStop);
      }); // Remove drag handlers

      DRAG_EVENT_TYPES.forEach(function (element) {
        _this.element.ownerDocument.removeEventListener(element, _this.onDrag);
      }); // Set needsOnRelease flag so event fires on next update

      _this.setState({
        needsOnRelease: true,
        isValid: true
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "_onDrag", function (evt) {
      // Do nothing if component is disabled or we have no event
      if (_this.props.disabled || !evt) {
        return;
      }

      var clientX;

      if ('clientX' in evt) {
        clientX = evt.clientX;
      } else if ('touches' in evt && 0 in evt.touches && 'clientX' in evt.touches[0]) {
        clientX = evt.touches[0].clientX;
      } else {
        // Do nothing if we have no valid clientX
        return;
      }

      var _this$calcValue = _this.calcValue({
        clientX: clientX
      }),
          value = _this$calcValue.value,
          left = _this$calcValue.left;

      _this.setState({
        value: value,
        left: left,
        isValid: true
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onDrag", (0, _lodash.default)(_this._onDrag, EVENT_THROTTLE, {
      leading: true,
      trailing: false
    }));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onKeyDown", function (evt) {
      // Do nothing if component is disabled or we don't have a valid event
      if (_this.props.disabled || !('which' in evt)) {
        return;
      }

      var which = Number.parseInt(evt.which);
      var delta = 0;

      if ((0, _match.matches)(which, [keys.ArrowDown, keys.ArrowLeft])) {
        delta = -_this.props.step;
      } else if ((0, _match.matches)(which, [keys.ArrowUp, keys.ArrowRight])) {
        delta = _this.props.step;
      } else {
        // Ignore keys we don't want to handle
        return;
      } // If shift was held, account for the stepMultiplier


      if (evt.shiftKey) {
        var stepMultiplier = _this.props.stepMultiplier || _this.props.stepMuliplier;
        delta *= stepMultiplier;
      }

      Math.floor(_this.state.value / _this.props.step) * _this.props.step;

      var _this$calcValue2 = _this.calcValue({
        // Ensures custom value from `<input>` won't cause skipping next stepping point with right arrow key,
        // e.g. Typing 51 in `<input>`, moving focus onto the thumb and the hitting right arrow key should yield 52 instead of 54
        value: (delta > 0 ? Math.floor(_this.state.value / _this.props.step) * _this.props.step : _this.state.value) + delta
      }),
          value = _this$calcValue2.value,
          left = _this$calcValue2.left;

      _this.setState({
        value: value,
        left: left,
        isValid: true
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onChange", function (evt) {
      // Do nothing if component is disabled
      if (_this.props.disabled) {
        return;
      } // Do nothing if we have no valid event, target, or value


      if (!evt || !('target' in evt) || typeof evt.target.value !== 'string') {
        return;
      }

      var targetValue = Number.parseFloat(evt.target.value); // Avoid calling calcValue for invalid numbers, but still update the state

      if (isNaN(targetValue)) {
        _this.setState({
          value: evt.target.value
        });
      } else {
        var _this$calcValue3 = _this.calcValue({
          value: targetValue,
          useRawValue: true
        }),
            value = _this$calcValue3.value,
            left = _this$calcValue3.left;

        _this.setState({
          value: value,
          left: left,
          needsOnRelease: true
        });
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onBlur", function (evt) {
      // Do nothing if we have no valid event, target, or value
      if (!evt || !('target' in evt) || typeof evt.target.value !== 'string') {
        return;
      } // determine validity of input change after clicking out of input


      var validity = evt.target.checkValidity();

      _this.setState({
        isValid: validity
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "calcValue", function (_ref) {
      var _ref$clientX = _ref.clientX,
          clientX = _ref$clientX === void 0 ? null : _ref$clientX,
          _ref$value = _ref.value,
          value = _ref$value === void 0 ? null : _ref$value,
          _ref$useRawValue = _ref.useRawValue,
          useRawValue = _ref$useRawValue === void 0 ? false : _ref$useRawValue;
      var range = _this.props.max - _this.props.min;

      var boundingRect = _this.element.getBoundingClientRect();

      var totalSteps = range / _this.props.step;
      var width = boundingRect.right - boundingRect.left; // Enforce a minimum width of at least 1 for calculations

      if (width <= 0) {
        width = 1;
      } // If a clientX is specified, use it to calculate the leftPercent. If not,
      // use the provided value or state's value to calculate it instead.


      var leftPercent;

      if (clientX != null) {
        var leftOffset = clientX - boundingRect.left;
        leftPercent = leftOffset / width;
      } else {
        if (value == null) {
          value = _this.state.value;
        } // prevent NaN calculation if the range is 0


        leftPercent = range === 0 ? 0 : (value - _this.props.min) / range;
      }

      if (useRawValue) {
        // Adjusts only for min/max of thumb position
        return {
          value: value,
          left: Math.min(1, Math.max(0, leftPercent)) * 100
        };
      }

      var steppedValue = Math.round(leftPercent * totalSteps) * _this.props.step;

      var steppedPercent = _this.clamp(steppedValue / range, 0, 1);

      steppedValue = _this.clamp(steppedValue + _this.props.min, _this.props.min, _this.props.max);
      return {
        value: steppedValue,
        left: steppedPercent * 100
      };
    });
    return _this;
  }

  (0, _createClass2.default)(Slider, [{
    key: "componentDidMount",
    value:
    /**
     * Sets up initial slider position and value in response to component mount.
     */
    function componentDidMount() {
      if (this.element) {
        var _this$calcValue4 = this.calcValue({
          useRawValue: true
        }),
            value = _this$calcValue4.value,
            left = _this$calcValue4.left;

        this.setState({
          value: value,
          left: left
        });
      }
    }
    /**
     * Handles firing of `onChange` and `onRelease` callbacks to parent in
     * response to state changes.
     *
     * @param {*} prevProps prevProps
     * @param {*} prevState The previous Slider state, used to see if callbacks
     * should be called.
     */

  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      // Fire onChange event handler if present, if there's a usable value, and
      // if the value is different from the last one
      if (this.state.value !== '' && prevState.value !== this.state.value && typeof this.props.onChange === 'function') {
        // TODO: pass event object as first param (breaking change/feat for v11)
        this.props.onChange({
          value: this.state.value
        });
      } // Fire onRelease event handler if present and if needed


      if (this.state.needsOnRelease && typeof this.props.onRelease === 'function') {
        // TODO: pass event object as first param (breaking change/feat for v11)
        this.props.onRelease({
          value: this.state.value
        }); // Reset the flag

        this.setState({
          needsOnRelease: false
        });
      } // If value from props does not change, do nothing here.
      // Otherwise, do prop -> state sync without "value capping".


      if (prevProps.value === this.props.value && prevProps.max === this.props.max && prevProps.min === this.props.min) {
        return;
      }

      this.setState(this.calcValue({
        value: this.props.value,
        useRawValue: true
      }));
    }
    /**
     * Synonymous to ECMA2017+ `Math.clamp`.
     *
     * @param {number} val
     * @param {number} min
     * @param {number} max
     *
     * @returns `val` if `max>=val>=min`; `min` if `val<min`; `max` if `val>max`.
     */

  }, {
    key: "clamp",
    value: function clamp(val, min, max) {
      return Math.max(min, Math.min(val, max));
    }
    /**
     * Sets up "drag" event handlers and calls `this.onDrag` in case dragging
     * started on somewhere other than the thumb without a corresponding "move"
     * event.
     *
     * @param {Event} evt The event.
     */

  }, {
    key: "render",
    value: function render() {
      var _classNames3,
          _this2 = this;

      var _this$props = this.props,
          ariaLabelInput = _this$props.ariaLabelInput,
          className = _this$props.className,
          hideTextInput = _this$props.hideTextInput,
          _this$props$id = _this$props.id,
          id = _this$props$id === void 0 ? this.inputId = this.inputId || "__carbon-slider_".concat(Math.random().toString(36).substr(2)) : _this$props$id,
          min = _this$props.min,
          minLabel = _this$props.minLabel,
          max = _this$props.max,
          maxLabel = _this$props.maxLabel,
          _this$props$formatLab = _this$props.formatLabel,
          formatLabel = _this$props$formatLab === void 0 ? defaultFormatLabel : _this$props$formatLab,
          labelText = _this$props.labelText,
          step = _this$props.step,
          stepMuliplier = _this$props.stepMuliplier,
          stepMultiplier = _this$props.stepMultiplier,
          inputType = _this$props.inputType,
          required = _this$props.required,
          disabled = _this$props.disabled,
          name = _this$props.name,
          light = _this$props.light,
          other = (0, _objectWithoutProperties2.default)(_this$props, _excluded);
      delete other.onRelease;
      delete other.invalid;
      var _this$state = this.state,
          value = _this$state.value,
          left = _this$state.left,
          isValid = _this$state.isValid;
      var scope = this.context;
      var enabled;

      if (scope.enabled) {
        enabled = scope.enabled('enable-v11-release');
      }

      var labelId = "".concat(id, "-label");
      var labelClasses = (0, _classnames.default)("".concat(prefix, "--label"), (0, _defineProperty2.default)({}, "".concat(prefix, "--label--disabled"), disabled));
      var sliderClasses = (0, _classnames.default)("".concat(prefix, "--slider"), (0, _defineProperty2.default)({}, "".concat(prefix, "--slider--disabled"), disabled), [enabled ? null : className]);
      var inputClasses = (0, _classnames.default)("".concat(prefix, "--text-input"), "".concat(prefix, "--slider-text-input"), (_classNames3 = {}, (0, _defineProperty2.default)(_classNames3, "".concat(prefix, "--text-input--light"), light), (0, _defineProperty2.default)(_classNames3, "".concat(prefix, "--text-input--invalid"), isValid === false), _classNames3));
      var filledTrackStyle = {
        transform: "translate(0%, -50%) scaleX(".concat(left / 100, ")")
      };
      var thumbStyle = {
        left: "".concat(left, "%")
      };
      var hiddenInputStyle = {
        display: 'none'
      };
      return /*#__PURE__*/_react.default.createElement("div", {
        className: enabled ? (0, _classnames.default)("".concat(prefix, "--form-item"), className) : "".concat(prefix, "--form-item")
      }, /*#__PURE__*/_react.default.createElement("label", {
        htmlFor: "".concat(id, "-input-for-slider"),
        className: labelClasses,
        id: labelId
      }, labelText), /*#__PURE__*/_react.default.createElement("div", {
        className: "".concat(prefix, "--slider-container")
      }, /*#__PURE__*/_react.default.createElement("span", {
        className: "".concat(prefix, "--slider__range-label")
      }, formatLabel(min, minLabel)), /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
        className: sliderClasses,
        ref: function ref(node) {
          _this2.element = node;
        },
        onMouseDown: this.onDragStart,
        onTouchStart: this.onDragStart,
        onKeyDown: this.onKeyDown,
        role: "presentation",
        tabIndex: -1,
        "data-invalid": isValid ? null : true
      }, other), /*#__PURE__*/_react.default.createElement("div", {
        className: "".concat(prefix, "--slider__thumb"),
        role: "slider",
        id: id,
        tabIndex: 0,
        "aria-labelledby": labelId,
        "aria-valuemax": max,
        "aria-valuemin": min,
        "aria-valuenow": value,
        style: thumbStyle
      }), /*#__PURE__*/_react.default.createElement("div", {
        className: "".concat(prefix, "--slider__track"),
        ref: function ref(node) {
          _this2.track = node;
        }
      }), /*#__PURE__*/_react.default.createElement("div", {
        className: "".concat(prefix, "--slider__filled-track"),
        style: filledTrackStyle
      })), /*#__PURE__*/_react.default.createElement("span", {
        className: "".concat(prefix, "--slider__range-label")
      }, formatLabel(max, maxLabel)), /*#__PURE__*/_react.default.createElement("input", {
        type: hideTextInput ? 'hidden' : inputType,
        style: hideTextInput ? hiddenInputStyle : null,
        id: "".concat(id, "-input-for-slider"),
        name: name,
        className: inputClasses,
        value: value,
        "aria-label": ariaLabelInput ? ariaLabelInput : null,
        disabled: disabled,
        required: required,
        min: min,
        max: max,
        step: step,
        onChange: this.onChange,
        onBlur: this.onBlur,
        "data-invalid": isValid ? null : true,
        "aria-invalid": isValid ? null : true
      })));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: // syncs invalid state and prop
    function getDerivedStateFromProps(props, state) {
      var isValid = state.isValid; // will override state in favor of invalid prop

      if (props.invalid === true && isValid === true) {
        return {
          isValid: false
        };
      }

      if (props.invalid === false && isValid === false) {
        return {
          isValid: true
        };
      } //if invalid prop is not provided, state will remain the same


      return null;
    }
  }]);
  return Slider;
}(_react.PureComponent);

exports.default = Slider;
(0, _defineProperty2.default)(Slider, "propTypes", {
  /**
   * The `ariaLabel` for the `<input>`.
   */
  ariaLabelInput: _propTypes.default.string,

  /**
   * The child nodes.
   */
  children: _propTypes.default.node,

  /**
   * The CSS class name for the slider.
   */
  className: _propTypes.default.string,

  /**
   * `true` to disable this slider.
   */
  disabled: _propTypes.default.bool,

  /**
   * The callback to format the label associated with the minimum/maximum value.
   */
  formatLabel: _propTypes.default.func,

  /**
   * `true` to hide the number input box.
   */
  hideTextInput: _propTypes.default.bool,

  /**
   * The ID of the `<input>`.
   */
  id: _propTypes.default.string,

  /**
   * The `type` attribute of the `<input>`.
   */
  inputType: _propTypes.default.string,

  /**
   * `true` to specify if the control is invalid.
   */
  invalid: _propTypes.default.bool,

  /**
   * The label for the slider.
   */
  labelText: _propTypes.default.node,

  /**
   * `true` to use the light version.
   */
  light: _propTypes.default.bool,

  /**
   * The maximum value.
   */
  max: _propTypes.default.number.isRequired,

  /**
   * The label associated with the maximum value.
   */
  maxLabel: _propTypes.default.string,

  /**
   * The minimum value.
   */
  min: _propTypes.default.number.isRequired,

  /**
   * The label associated with the minimum value.
   */
  minLabel: _propTypes.default.string,

  /**
   * The `name` attribute of the `<input>`.
   */
  name: _propTypes.default.string,

  /**
   * The callback to get notified of change in value.
   */
  onChange: _propTypes.default.func,

  /**
   * The callback to get notified of value on handle release.
   */
  onRelease: _propTypes.default.func,

  /**
   * `true` to specify if the control is required.
   */
  required: _propTypes.default.bool,

  /**
   * A value determining how much the value should increase/decrease by moving the thumb by mouse.
   */
  step: _propTypes.default.number,

  /**
   * A value determining how much the value should increase/decrease by Shift+arrow keys,
   * which will be `(max - min) / stepMuliplier`.
   */
  stepMuliplier: (0, _deprecate.default)(_propTypes.default.number, ' The `stepMuliplier` prop has been deprecated in favor of `stepMultiplier`. It will be removed in the next major release.'),

  /**
   * A value determining how much the value should increase/decrease by Shift+arrow keys,
   * which will be `(max - min) / stepMultiplier`.
   */
  stepMultiplier: _propTypes.default.number,

  /**
   * The value.
   */
  value: _propTypes.default.number.isRequired
});
(0, _defineProperty2.default)(Slider, "defaultProps", {
  hideTextInput: false,
  step: 1,
  stepMultiplier: 4,
  disabled: false,
  minLabel: '',
  maxLabel: '',
  inputType: 'number',
  ariaLabelInput: FeatureFlags.enabled('enable-v11-release') ? undefined : 'Slider number input',
  light: false
});
(0, _defineProperty2.default)(Slider, "contextType", _FeatureFlags.FeatureFlagContext);