"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _react = _interopRequireDefault(require("react"));

var _TextInput = _interopRequireDefault(require("../TextInput"));

var _enzyme = require("enzyme");

var _carbonComponents = require("carbon-components");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var prefix = _carbonComponents.settings.prefix;
describe('TextInput', function () {
  describe('renders as expected', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_TextInput.default, {
      id: "test",
      className: "extra-class",
      labelText: "testlabel",
      helperText: "testHelper",
      light: true
    }));

    var textInput = function textInput() {
      return wrapper.find('input');
    };

    describe('input', function () {
      var container;
      afterEach(function () {
        if (container && container.parentNode) {
          container.parentNode.removeChild(container);
        }

        container = null;
      });
      it('renders as expected', function () {
        expect(textInput().length).toBe(1);
      });
      it('should accept refs', function () {
        var MyComponent = /*#__PURE__*/function (_React$Component) {
          (0, _inherits2.default)(MyComponent, _React$Component);

          var _super = _createSuper(MyComponent);

          function MyComponent(props) {
            var _this;

            (0, _classCallCheck2.default)(this, MyComponent);
            _this = _super.call(this, props);
            _this.textInput = /*#__PURE__*/_react.default.createRef();
            _this.focus = _this.focus.bind((0, _assertThisInitialized2.default)(_this));
            return _this;
          }

          (0, _createClass2.default)(MyComponent, [{
            key: "focus",
            value: function focus() {
              this.textInput.current.focus();
            }
          }, {
            key: "render",
            value: function render() {
              return /*#__PURE__*/_react.default.createElement(_TextInput.default, {
                id: "test",
                labelText: "testlabel",
                ref: this.textInput
              });
            }
          }]);
          return MyComponent;
        }(_react.default.Component);

        container = document.createElement('div');
        container.id = 'container';
        document.body.appendChild(container);
        var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(MyComponent, null), {
          attachTo: document.querySelector('#container')
        });
        expect(document.activeElement.type).toBeUndefined();
        wrapper.instance().focus();
        expect(document.activeElement.type).toEqual('text');
      });
      it('has the expected classes', function () {
        expect(textInput().hasClass("".concat(prefix, "--text-input"))).toEqual(true);
      });
      it('should add extra classes that are passed via className', function () {
        expect(textInput().hasClass('extra-class')).toEqual(true);
      });
      it('has the expected classes for light', function () {
        wrapper.setProps({
          light: true
        });
        expect(textInput().hasClass("".concat(prefix, "--text-input--light"))).toEqual(true);
      });
      it('should set type as expected', function () {
        expect(textInput().props().type).toEqual('text');
        wrapper.setProps({
          type: 'email'
        });
        expect(textInput().props().type).toEqual('email');
      });
      it('should set value as expected', function () {
        expect(textInput().props().defaultValue).toEqual(undefined);
        wrapper.setProps({
          defaultValue: 'test'
        });
        expect(textInput().props().defaultValue).toEqual('test');
      });
      it('should set disabled as expected', function () {
        expect(textInput().props().disabled).toEqual(false);
        wrapper.setProps({
          disabled: true
        });
        expect(textInput().props().disabled).toEqual(true);
      });
      it('should set placeholder as expected', function () {
        expect(textInput().props().placeholder).not.toBeDefined();
        wrapper.setProps({
          placeholder: 'Enter text'
        });
        expect(textInput().props().placeholder).toEqual('Enter text');
      });
    });
    describe('label', function () {
      wrapper.setProps({
        labelText: 'Email Input'
      });
      var renderedLabel = wrapper.find('label');
      it('renders a label', function () {
        expect(renderedLabel.length).toBe(1);
      });
      it('has the expected classes', function () {
        expect(renderedLabel.hasClass("".concat(prefix, "--label"))).toEqual(true);
      });
      it('should set label as expected', function () {
        expect(renderedLabel.text()).toEqual('Email Input');
      });
    });
    describe('helper', function () {
      it('renders a helper', function () {
        var renderedHelper = wrapper.find(".".concat(prefix, "--form__helper-text"));
        expect(renderedHelper.length).toEqual(1);
      });
      it('renders children as expected', function () {
        wrapper.setProps({
          helperText: /*#__PURE__*/_react.default.createElement("span", null, "This is helper text.")
        });
        var renderedHelper = wrapper.find(".".concat(prefix, "--form__helper-text"));
        expect(renderedHelper.props().children).toEqual( /*#__PURE__*/_react.default.createElement("span", null, "This is helper text."));
      });
      it('should set helper text as expected', function () {
        wrapper.setProps({
          helperText: 'Helper text'
        });
        var renderedHelper = wrapper.find(".".concat(prefix, "--form__helper-text"));
        expect(renderedHelper.text()).toEqual('Helper text');
      });
    });
  });
  describe('events', function () {
    describe('disabled textinput', function () {
      var onClick = jest.fn();
      var onChange = jest.fn();
      var wrapper = (0, _enzyme.shallow)( /*#__PURE__*/_react.default.createElement(_TextInput.default, {
        id: "test",
        labelText: "testlabel",
        onClick: onClick,
        onChange: onChange,
        disabled: true
      }));
      var input = wrapper.find('input');
      it('should not invoke onClick', function () {
        input.simulate('click');
        expect(onClick).not.toHaveBeenCalled();
      });
      it('should not invoke onChange', function () {
        input.simulate('change');
        expect(onChange).not.toHaveBeenCalled();
      });
    });
    describe('enabled textinput', function () {
      var onClick = jest.fn();
      var onChange = jest.fn();
      var wrapper = (0, _enzyme.shallow)( /*#__PURE__*/_react.default.createElement(_TextInput.default, {
        labelText: "testlabel",
        id: "test",
        onClick: onClick,
        onChange: onChange
      }));
      var input = wrapper.find('input');
      var eventObject = {
        target: {
          defaultValue: 'test'
        }
      };
      it('should invoke onClick when input is clicked', function () {
        input.simulate('click');
        expect(onClick).toHaveBeenCalled();
      });
      it('should invoke onChange when input value is changed', function () {
        input.simulate('change', eventObject);
        expect(onChange).toHaveBeenCalledWith(eventObject);
      });
    });
  });
});