"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Theme = Theme;
exports.useTheme = useTheme;
exports.ThemeContext = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _usePrefix = require("../../internal/usePrefix");

var _LayerContext = require("../Layer/LayerContext");

var _excluded = ["as", "children", "className", "theme"];

var ThemeContext = /*#__PURE__*/_react.default.createContext({
  theme: 'white'
});
/**
 * Specify the theme to be applied to a page, or a region in a page
 */


exports.ThemeContext = ThemeContext;

function Theme(_ref) {
  var _cx;

  var _ref$as = _ref.as,
      BaseComponent = _ref$as === void 0 ? 'div' : _ref$as,
      children = _ref.children,
      customClassName = _ref.className,
      theme = _ref.theme,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var className = (0, _classnames.default)(customClassName, (_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--white"), theme === 'white'), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--g10"), theme === 'g10'), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--g90"), theme === 'g90'), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--g100"), theme === 'g100'), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--layer-one"), true), _cx));

  var value = _react.default.useMemo(function () {
    return {
      theme: theme
    };
  }, [theme]);

  return /*#__PURE__*/_react.default.createElement(ThemeContext.Provider, {
    value: value
  }, /*#__PURE__*/_react.default.createElement(_LayerContext.LayerContext.Provider, {
    value: 1
  }, /*#__PURE__*/_react.default.createElement(BaseComponent, (0, _extends2.default)({}, rest, {
    className: className
  }), children)));
}

Theme.propTypes = {
  /**
   * Specify a custom component or element to be rendered as the top-level
   * element in the component
   */
  as: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.string, _propTypes.default.elementType]),

  /**
   * Provide child elements to be rendered inside of `Theme`
   */
  children: _propTypes.default.node,

  /**
   * Provide a custom class name to be used on the outermost element rendered by
   * the component
   */
  className: _propTypes.default.string,

  /**
   * Specify the theme
   */
  theme: _propTypes.default.oneOf(['white', 'g10', 'g90', 'g100'])
};
/**
 * Get access to the current theme
 */

function useTheme() {
  return _react.default.useContext(ThemeContext);
}