"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.createCustomSideNavLink = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _Link = _interopRequireWildcard(require("./Link"));

var _SideNavIcon = _interopRequireDefault(require("./SideNavIcon"));

var _SideNavItem = _interopRequireDefault(require("./SideNavItem"));

var _SideNavLinkText = _interopRequireDefault(require("./SideNavLinkText"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["className", "children", "renderIcon", "isActive", "large"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var SideNavLink = /*#__PURE__*/_react.default.forwardRef(function SideNavLink(_ref, ref) {
  var _cx;

  var customClassName = _ref.className,
      children = _ref.children,
      IconElement = _ref.renderIcon,
      isActive = _ref.isActive,
      large = _ref.large,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var className = (0, _classnames.default)((_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--side-nav__link"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--side-nav__link--current"), isActive), (0, _defineProperty2.default)(_cx, customClassName, !!customClassName), _cx));
  return /*#__PURE__*/_react.default.createElement(_SideNavItem.default, {
    large: large
  }, /*#__PURE__*/_react.default.createElement(_Link.default, (0, _extends2.default)({}, rest, {
    className: className,
    ref: ref
  }), IconElement && /*#__PURE__*/_react.default.createElement(_SideNavIcon.default, {
    small: true
  }, /*#__PURE__*/_react.default.createElement(IconElement, null)), /*#__PURE__*/_react.default.createElement(_SideNavLinkText.default, null, children)));
});

SideNavLink.displayName = 'SideNavLink';
SideNavLink.propTypes = _objectSpread(_objectSpread({}, _Link.LinkPropTypes), {}, {
  /**
   * Specify the text content for the link
   */
  children: _propTypes.default.node.isRequired,

  /**
   * Provide an optional class to be applied to the containing node
   */
  className: _propTypes.default.string,

  /**
   * Property to indicate if the side nav container is open (or not). Use to
   * keep local state and styling in step with the SideNav expansion state.
   */
  isSideNavExpanded: _propTypes.default.bool,

  /**
   * Specify if this is a large variation of the SideNavLink
   */
  large: _propTypes.default.bool,

  /**
   * Provide an icon to render in the side navigation link. Should be a React class.
   */
  renderIcon: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object])
});
SideNavLink.defaultProps = {
  element: 'a',
  large: false
}; // eslint-disable-next-line react/display-name

var createCustomSideNavLink = function createCustomSideNavLink(element) {
  return function (props) {
    return /*#__PURE__*/_react.default.createElement(SideNavLink, (0, _extends2.default)({
      element: element
    }, props));
  };
};

exports.createCustomSideNavLink = createCustomSideNavLink;
var _default = SideNavLink;
exports.default = _default;