"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SideNavWLargeSideNavItems = exports.SideNavRailWHeader = exports.SideNavRail = exports.FixedSideNavWDivider = exports.FixedSideNavWIcons = exports.FixedSideNav = exports.HeaderBaseWActionsAndSwitcher = exports.HeaderBaseWActionsAndRightPanel = exports.HeaderBaseWSideNav = exports.HeaderBaseWNavigationActionsAndSideNav = exports.HeaderBaseWNavigationAndActions = exports.HeaderBaseWSkipToContent = exports.HeaderBaseWActions = exports.HeaderBaseWNavigation = exports.HeaderBase = exports.default = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _classnames = _interopRequireDefault(require("classnames"));

var _iconsReact = require("@carbon/icons-react");

var _addonActions = require("@storybook/addon-actions");

var _react = _interopRequireWildcard(require("react"));

var _storybookReadme = require("storybook-readme");

var _README = _interopRequireDefault(require("./README.md"));

var _HeaderContainer = _interopRequireDefault(require("./HeaderContainer"));

var _UIShell = require("../UIShell");

var _Modal = _interopRequireDefault(require("../Modal"));

var _Button = _interopRequireDefault(require("../Button"));

var _UIShell2 = _interopRequireDefault(require("./UIShell.mdx"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
_UIShell.SideNav.displayName = 'SideNav';
_UIShell.SideNavMenu.displayName = 'SideNavMenu';
_UIShell.SideNavMenuItem.displayName = 'SideNavMenuItem';

var Fade16 = function Fade16() {
  return /*#__PURE__*/_react.default.createElement("svg", {
    width: "16",
    height: "16",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 32 32",
    "aria-hidden": "true"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M8.24 25.14L7 26.67a14 14 0 0 0 4.18 2.44l.68-1.88a12 12 0 0 1-3.62-2.09zm-4.05-7.07l-2 .35A13.89 13.89 0 0 0 3.86 23l1.73-1a11.9 11.9 0 0 1-1.4-3.93zm7.63-13.31l-.68-1.88A14 14 0 0 0 7 5.33l1.24 1.53a12 12 0 0 1 3.58-2.1zM5.59 10L3.86 9a13.89 13.89 0 0 0-1.64 4.54l2 .35A11.9 11.9 0 0 1 5.59 10zM16 2v2a12 12 0 0 1 0 24v2a14 14 0 0 0 0-28z"
  }));
};

var StoryContent = function StoryContent(_ref) {
  var _ref$useResponsiveOff = _ref.useResponsiveOffset,
      useResponsiveOffset = _ref$useResponsiveOff === void 0 ? true : _ref$useResponsiveOff;

  var _useState = (0, _react.useState)(false),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      open = _useState2[0],
      setOpen = _useState2[1];

  var classNameFirstColumn = (0, _classnames.default)({
    'bx--col-lg-13': true,
    'bx--offset-lg-3': useResponsiveOffset
  });

  var content = /*#__PURE__*/_react.default.createElement("div", {
    className: "bx--grid"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "bx--row"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: classNameFirstColumn
  }, /*#__PURE__*/_react.default.createElement("h2", {
    style: {
      margin: '0 0 30px'
    }
  }, "Purpose and function"), /*#__PURE__*/_react.default.createElement("p", null, "The shell is perhaps the most crucial piece of any UI built with", /*#__PURE__*/_react.default.createElement("a", {
    href: "www.carbondesignsystem.com"
  }, " Carbon"), ". It contains the shared navigation framework for the entire design system and ties the products in IBM\u2019s portfolio together in a cohesive and elegant way. The shell is the home of the topmost navigation, where users can quickly and dependably gain their bearings and move between pages.", /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("br", null), "The shell was designed with maximum flexibility built in, to serve the needs of a broad range of products and users. Adopting the shell ensures compliance with IBM design standards, simplifies development efforts, and provides great user experiences. All IBM products built with Carbon are required to use the shell\u2019s header.", /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("br", null), "To better understand the purpose and function of the UI shell, consider the \u201Cshell\u201D of MacOS, which contains the Apple menu, top-level navigation, and universal, OS-level controls at the top of the screen, as well as a universal dock along the bottom or side of the screen. The Carbon UI shell is roughly analogous in function to these parts of the Mac UI. For example, the app switcher portion of the shell can be compared to the dock in MacOS."), /*#__PURE__*/_react.default.createElement("h2", {
    style: {
      margin: '30px 0'
    }
  }, "Header responsive behavior"), /*#__PURE__*/_react.default.createElement("p", null, "As a header scales down to fit smaller screen sizes, headers with persistent side nav menus should have the side nav collapse into \u201Chamburger\u201D menu. See the example to better understand responsive behavior of the header."), /*#__PURE__*/_react.default.createElement("h2", {
    style: {
      margin: '30px 0'
    }
  }, "Secondary navigation"), /*#__PURE__*/_react.default.createElement("p", null, "The side-nav contains secondary navigation and fits below the header. It can be configured to be either fixed-width or flexible, with only one level of nested items allowed. Both links and category lists can be used in the side-nav and may be mixed together. There are several configurations of the side-nav, but only one configuration should be used per product section. If tabs are needed on a page when using a side-nav, then the tabs are secondary in hierarchy to the side-nav."), /*#__PURE__*/_react.default.createElement(_Button.default, {
    onClick: function onClick() {
      return setOpen(true);
    }
  }, "Launch modal"), /*#__PURE__*/_react.default.createElement(_Modal.default, {
    modalHeading: "Add a custom domain",
    modalLabel: "Account resources",
    primaryButtonText: "Add",
    secondaryButtonText: "Cancel",
    open: open,
    onRequestClose: function onRequestClose() {
      return setOpen(false);
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    style: {
      marginBottom: '1rem'
    }
  }, "Custom domains direct requests for your apps in this Cloud Foundry organization to a URL that you own. A custom domain can be a shared domain, a shared subdomain, or a shared domain and host.")))));

  var style = {
    height: '100%'
  };

  if (useResponsiveOffset) {
    style.margin = '0';
    style.width = '100%';
  }

  return /*#__PURE__*/_react.default.createElement(_UIShell.Content, {
    id: "main-content",
    style: style
  }, content);
};

var _default = {
  title: 'Components/UI Shell',
  parameters: {
    docs: {
      page: _UIShell2.default
    },
    subcomponents: {
      Content: _UIShell.Content,
      Header: _UIShell.Header,
      HeaderMenuButton: _UIShell.HeaderMenuButton,
      HeaderName: _UIShell.HeaderName,
      HeaderNavigation: _UIShell.HeaderNavigation,
      HeaderMenu: _UIShell.HeaderMenu,
      HeaderMenuItem: _UIShell.HeaderMenuItem,
      HeaderGlobalBar: _UIShell.HeaderGlobalBar,
      HeaderGlobalAction: _UIShell.HeaderGlobalAction,
      HeaderPanel: _UIShell.HeaderPanel,
      HeaderSideNavItems: _UIShell.HeaderSideNavItems,
      SkipToContent: _UIShell.SkipToContent,
      SideNav: _UIShell.SideNav,
      SideNavItems: _UIShell.SideNavItems,
      SideNavDivider: _UIShell.SideNavDivider,
      SideNavLink: _UIShell.SideNavLink,
      SideNavMenu: _UIShell.SideNavMenu,
      SideNavMenuItem: _UIShell.SideNavMenuItem,
      Switcher: _UIShell.Switcher,
      SwitcherItem: _UIShell.SwitcherItem,
      SwitcherDivider: _UIShell.SwitcherDivider
    }
  }
};
exports.default = _default;
var HeaderBase = (0, _storybookReadme.withReadme)(_README.default, function () {
  return /*#__PURE__*/_react.default.createElement(_UIShell.Header, {
    "aria-label": "IBM Platform Name"
  }, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderName, {
    href: "#",
    prefix: "IBM"
  }, "[Platform]"));
});
exports.HeaderBase = HeaderBase;
var HeaderBaseWNavigation = (0, _storybookReadme.withReadme)(_README.default, function () {
  return /*#__PURE__*/_react.default.createElement(_HeaderContainer.default, {
    render: function render(_ref2) {
      var isSideNavExpanded = _ref2.isSideNavExpanded,
          onClickSideNavExpand = _ref2.onClickSideNavExpand;
      return /*#__PURE__*/_react.default.createElement(_UIShell.Header, {
        "aria-label": "IBM Platform Name"
      }, /*#__PURE__*/_react.default.createElement(_UIShell.SkipToContent, null), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuButton, {
        "aria-label": "Open menu",
        onClick: onClickSideNavExpand,
        isActive: isSideNavExpanded
      }), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderName, {
        href: "#",
        prefix: "IBM"
      }, "[Platform]"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderNavigation, {
        "aria-label": "IBM [Platform]"
      }, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Link 1"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Link 2"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Link 3"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenu, {
        "aria-label": "Link 4",
        menuLinkName: "Link 4",
        isCurrentPage: true
      }, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 1"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#",
        isCurrentPage: true
      }, "Sub-link 2"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 3"))), /*#__PURE__*/_react.default.createElement(_UIShell.SideNav, {
        "aria-label": "Side navigation",
        expanded: isSideNavExpanded,
        isPersistent: false
      }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavItems, null, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderSideNavItems, null, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Link 1"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Link 2"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Link 3"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenu, {
        "aria-label": "Link 4",
        menuLinkName: "Link 4"
      }, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 1"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 2"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 3"))))));
    }
  });
});
exports.HeaderBaseWNavigation = HeaderBaseWNavigation;
HeaderBaseWNavigation.storyName = 'Header Base w/ Navigation';
var HeaderBaseWActions = (0, _storybookReadme.withReadme)(_README.default, function () {
  return /*#__PURE__*/_react.default.createElement(_UIShell.Header, {
    "aria-label": "IBM Platform Name"
  }, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderName, {
    href: "#",
    prefix: "IBM"
  }, "[Platform]"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderGlobalBar, null, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderGlobalAction, {
    "aria-label": "Search",
    onClick: (0, _addonActions.action)('search click')
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Search20, null)), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderGlobalAction, {
    "aria-label": "Notifications",
    onClick: (0, _addonActions.action)('notification click')
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Notification20, null)), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderGlobalAction, {
    "aria-label": "App Switcher",
    onClick: (0, _addonActions.action)('app-switcher click'),
    tooltipAlignment: "end"
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.AppSwitcher20, null))));
});
exports.HeaderBaseWActions = HeaderBaseWActions;
HeaderBaseWActions.storyName = 'Header Base w/ Actions';
var HeaderBaseWSkipToContent = (0, _storybookReadme.withReadme)(_README.default, function () {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_UIShell.Header, {
    "aria-label": "IBM Platform Name"
  }, /*#__PURE__*/_react.default.createElement(_UIShell.SkipToContent, null), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderName, {
    href: "#",
    prefix: "IBM"
  }, "[Platform]"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderGlobalBar, null, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderGlobalAction, {
    "aria-label": "Search",
    onClick: (0, _addonActions.action)('search click')
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Search20, null)), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderGlobalAction, {
    "aria-label": "Notifications",
    onClick: (0, _addonActions.action)('notification click')
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Notification20, null)), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderGlobalAction, {
    "aria-label": "App Switcher",
    onClick: (0, _addonActions.action)('app-switcher click'),
    tooltipAlignment: "end"
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.AppSwitcher20, null)))), /*#__PURE__*/_react.default.createElement(StoryContent, null));
});
exports.HeaderBaseWSkipToContent = HeaderBaseWSkipToContent;
HeaderBaseWSkipToContent.storyName = 'Header Base w/ SkipToContent';
var HeaderBaseWNavigationAndActions = (0, _storybookReadme.withReadme)(_README.default, function () {
  return /*#__PURE__*/_react.default.createElement(_HeaderContainer.default, {
    render: function render(_ref3) {
      var isSideNavExpanded = _ref3.isSideNavExpanded,
          onClickSideNavExpand = _ref3.onClickSideNavExpand;
      return /*#__PURE__*/_react.default.createElement(_UIShell.Header, {
        "aria-label": "IBM Platform Name"
      }, /*#__PURE__*/_react.default.createElement(_UIShell.SkipToContent, null), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuButton, {
        "aria-label": "Open menu",
        onClick: onClickSideNavExpand,
        isActive: isSideNavExpanded
      }), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderName, {
        href: "#",
        prefix: "IBM"
      }, "[Platform]"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderNavigation, {
        "aria-label": "IBM [Platform]"
      }, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Link 1"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Link 2"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Link 3"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenu, {
        "aria-label": "Link 4",
        menuLinkName: "Link 4"
      }, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 1"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 2"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 3"))), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderGlobalBar, null, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderGlobalAction, {
        "aria-label": "Search",
        onClick: (0, _addonActions.action)('search click')
      }, /*#__PURE__*/_react.default.createElement(_iconsReact.Search20, null)), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderGlobalAction, {
        "aria-label": "Notifications",
        onClick: (0, _addonActions.action)('notification click')
      }, /*#__PURE__*/_react.default.createElement(_iconsReact.Notification20, null)), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderGlobalAction, {
        "aria-label": "App Switcher",
        onClick: (0, _addonActions.action)('app-switcher click'),
        tooltipAlignment: "end"
      }, /*#__PURE__*/_react.default.createElement(_iconsReact.AppSwitcher20, null))), /*#__PURE__*/_react.default.createElement(_UIShell.SideNav, {
        "aria-label": "Side navigation",
        expanded: isSideNavExpanded,
        isPersistent: false
      }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavItems, null, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderSideNavItems, null, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Link 1"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Link 2"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Link 3"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenu, {
        "aria-label": "Link 4",
        menuLinkName: "Link 4"
      }, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 1"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 2"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 3"))))));
    }
  });
});
exports.HeaderBaseWNavigationAndActions = HeaderBaseWNavigationAndActions;
HeaderBaseWNavigationAndActions.storyName = 'Header Base w/ Navigation and Actions';
var HeaderBaseWNavigationActionsAndSideNav = (0, _storybookReadme.withReadme)(_README.default, function () {
  return /*#__PURE__*/_react.default.createElement(_HeaderContainer.default, {
    render: function render(_ref4) {
      var isSideNavExpanded = _ref4.isSideNavExpanded,
          onClickSideNavExpand = _ref4.onClickSideNavExpand;
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_UIShell.Header, {
        "aria-label": "IBM Platform Name"
      }, /*#__PURE__*/_react.default.createElement(_UIShell.SkipToContent, null), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuButton, {
        "aria-label": "Open menu",
        onClick: onClickSideNavExpand,
        isActive: isSideNavExpanded
      }), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderName, {
        href: "#",
        prefix: "IBM"
      }, "[Platform]"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderNavigation, {
        "aria-label": "IBM [Platform]"
      }, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Link 1"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Link 2"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Link 3"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenu, {
        "aria-label": "Link 4",
        menuLinkName: "Link 4"
      }, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#one"
      }, "Sub-link 1"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#two"
      }, "Sub-link 2"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#three"
      }, "Sub-link 3"))), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderGlobalBar, null, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderGlobalAction, {
        "aria-label": "Search",
        onClick: (0, _addonActions.action)('search click')
      }, /*#__PURE__*/_react.default.createElement(_iconsReact.Search20, null)), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderGlobalAction, {
        "aria-label": "Notifications",
        onClick: (0, _addonActions.action)('notification click')
      }, /*#__PURE__*/_react.default.createElement(_iconsReact.Notification20, null)), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderGlobalAction, {
        "aria-label": "App Switcher",
        onClick: (0, _addonActions.action)('app-switcher click'),
        tooltipAlignment: "end"
      }, /*#__PURE__*/_react.default.createElement(_iconsReact.AppSwitcher20, null))), /*#__PURE__*/_react.default.createElement(_UIShell.SideNav, {
        "aria-label": "Side navigation",
        expanded: isSideNavExpanded
      }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavItems, null, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderSideNavItems, {
        hasDivider: true
      }, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Link 1"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Link 2"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Link 3"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenu, {
        "aria-label": "Link 4",
        menuLinkName: "Link 4"
      }, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 1"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 2"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 3"))), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenu, {
        renderIcon: Fade16,
        title: "Category title"
      }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link")), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenu, {
        renderIcon: Fade16,
        title: "Category title"
      }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link")), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenu, {
        renderIcon: Fade16,
        title: "Category title",
        isActive: true
      }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        "aria-current": "page",
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link")), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavLink, {
        renderIcon: Fade16,
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavLink, {
        renderIcon: Fade16,
        href: "javascript:void(0)"
      }, "Link")))), /*#__PURE__*/_react.default.createElement(StoryContent, null));
    }
  });
});
exports.HeaderBaseWNavigationActionsAndSideNav = HeaderBaseWNavigationActionsAndSideNav;
HeaderBaseWNavigationActionsAndSideNav.storyName = 'Header Base w/ Navigation, Actions and SideNav';
var HeaderBaseWSideNav = (0, _storybookReadme.withReadme)(_README.default, function () {
  return /*#__PURE__*/_react.default.createElement(_HeaderContainer.default, {
    render: function render(_ref5) {
      var isSideNavExpanded = _ref5.isSideNavExpanded,
          onClickSideNavExpand = _ref5.onClickSideNavExpand;
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_UIShell.Header, {
        "aria-label": "IBM Platform Name"
      }, /*#__PURE__*/_react.default.createElement(_UIShell.SkipToContent, null), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuButton, {
        "aria-label": "Open menu",
        onClick: onClickSideNavExpand,
        isActive: isSideNavExpanded
      }), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderName, {
        href: "#",
        prefix: "IBM"
      }, "[Platform]"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNav, {
        "aria-label": "Side navigation",
        expanded: isSideNavExpanded
      }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavItems, null, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenu, {
        renderIcon: Fade16,
        title: "Category title"
      }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link")), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenu, {
        renderIcon: Fade16,
        title: "Category title",
        isActive: true
      }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        "aria-current": "page",
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link")), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenu, {
        renderIcon: Fade16,
        title: "Category title"
      }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link")), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavLink, {
        renderIcon: Fade16,
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavLink, {
        renderIcon: Fade16,
        href: "javascript:void(0)"
      }, "Link")))), /*#__PURE__*/_react.default.createElement(StoryContent, null));
    }
  });
});
exports.HeaderBaseWSideNav = HeaderBaseWSideNav;
HeaderBaseWSideNav.storyName = 'Header Base w/ SideNav';
var HeaderBaseWActionsAndRightPanel = (0, _storybookReadme.withReadme)(_README.default, function () {
  var _useState3 = (0, _react.useState)(false),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      expanded = _useState4[0],
      setExpanded = _useState4[1];

  var toggleRightPanel = function toggleRightPanel() {
    setExpanded(!expanded);
  };

  return /*#__PURE__*/_react.default.createElement(_UIShell.Header, {
    "aria-label": "IBM Platform Name"
  }, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderName, {
    href: "#",
    prefix: "IBM"
  }, "[Platform]"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderGlobalBar, null, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderGlobalAction, {
    tooltipAlignment: "end",
    isActive: expanded,
    "aria-label": "Notifications",
    onClick: toggleRightPanel
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Notification20, null))), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderPanel, {
    "aria-label": "Header Panel",
    expanded: expanded
  }));
});
exports.HeaderBaseWActionsAndRightPanel = HeaderBaseWActionsAndRightPanel;
HeaderBaseWActionsAndRightPanel.storyName = 'Header Base w/ Actions and Right Panel with Animation';
var HeaderBaseWActionsAndSwitcher = (0, _storybookReadme.withReadme)(_README.default, function () {
  return /*#__PURE__*/_react.default.createElement(_UIShell.Header, {
    "aria-label": "IBM Platform Name"
  }, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderName, {
    href: "#",
    prefix: "IBM"
  }, "[Platform]"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderGlobalBar, null, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderGlobalAction, {
    "aria-label": "Search",
    onClick: (0, _addonActions.action)('search click')
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Search20, null)), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderGlobalAction, {
    "aria-label": "Notifications",
    onClick: (0, _addonActions.action)('notification click')
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Notification20, null)), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderGlobalAction, {
    "aria-label": "App Switcher",
    isActive: true,
    onClick: (0, _addonActions.action)('app-switcher click'),
    tooltipAlignment: "end"
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.AppSwitcher20, null))), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderPanel, {
    "aria-label": "Header Panel",
    expanded: true
  }, /*#__PURE__*/_react.default.createElement(_UIShell.Switcher, {
    "aria-label": "Switcher Container"
  }, /*#__PURE__*/_react.default.createElement(_UIShell.SwitcherItem, {
    isSelected: true,
    "aria-label": "Link 1",
    href: "#"
  }, "Link 1"), /*#__PURE__*/_react.default.createElement(_UIShell.SwitcherDivider, null), /*#__PURE__*/_react.default.createElement(_UIShell.SwitcherItem, {
    href: "#",
    "aria-label": "Link 2"
  }, "Link 2"), /*#__PURE__*/_react.default.createElement(_UIShell.SwitcherItem, {
    href: "#",
    "aria-label": "Link 3"
  }, "Link 3"), /*#__PURE__*/_react.default.createElement(_UIShell.SwitcherItem, {
    href: "#",
    "aria-label": "Link 4"
  }, "Link 4"), /*#__PURE__*/_react.default.createElement(_UIShell.SwitcherItem, {
    href: "#",
    "aria-label": "Link 5"
  }, "Link 5"), /*#__PURE__*/_react.default.createElement(_UIShell.SwitcherDivider, null), /*#__PURE__*/_react.default.createElement(_UIShell.SwitcherItem, {
    href: "#",
    "aria-label": "Link 6"
  }, "Link 6"))));
});
exports.HeaderBaseWActionsAndSwitcher = HeaderBaseWActionsAndSwitcher;
HeaderBaseWActionsAndSwitcher.storyName = 'Header Base w/ Actions and Switcher';
var FixedSideNav = (0, _storybookReadme.withReadme)(_README.default, function () {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_UIShell.SideNav, {
    isFixedNav: true,
    expanded: true,
    isChildOfHeader: false,
    "aria-label": "Side navigation"
  }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavItems, null, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenu, {
    title: "L0 menu"
  }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item")), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenu, {
    title: "L0 menu",
    isActive: true
  }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    "aria-current": "page",
    href: "javascript:void(0)"
  }, "L0 menu item"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item")), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenu, {
    title: "L0 menu"
  }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item")), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavLink, {
    href: "javascript:void(0)"
  }, "L0 link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavLink, {
    href: "javascript:void(0)"
  }, "L0 link"))), /*#__PURE__*/_react.default.createElement(StoryContent, {
    useResponsiveOffset: false
  }));
});
exports.FixedSideNav = FixedSideNav;
FixedSideNav.storyName = 'Fixed SideNav';
var FixedSideNavWIcons = (0, _storybookReadme.withReadme)(_README.default, function () {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_UIShell.SideNav, {
    isFixedNav: true,
    expanded: true,
    isChildOfHeader: false,
    "aria-label": "Side navigation"
  }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavItems, null, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenu, {
    renderIcon: Fade16,
    title: "Category title"
  }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link")), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenu, {
    renderIcon: Fade16,
    title: "Category title",
    isActive: true
  }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    "aria-current": "page",
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link")), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenu, {
    renderIcon: Fade16,
    title: "Category title"
  }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link")), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavLink, {
    renderIcon: Fade16,
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavLink, {
    renderIcon: Fade16,
    href: "javascript:void(0)"
  }, "Link"))), /*#__PURE__*/_react.default.createElement(StoryContent, {
    useResponsiveOffset: false
  }));
});
exports.FixedSideNavWIcons = FixedSideNavWIcons;
FixedSideNavWIcons.storyName = 'Fixed SideNav w/ Icons';
var FixedSideNavWDivider = (0, _storybookReadme.withReadme)(_README.default, function () {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_UIShell.SideNav, {
    isFixedNav: true,
    expanded: true,
    isChildOfHeader: false,
    "aria-label": "Side navigation"
  }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavItems, null, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenu, {
    title: "L0 menu"
  }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item")), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenu, {
    title: "L0 menu",
    isActive: true
  }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    "aria-current": "page",
    href: "javascript:void(0)"
  }, "L0 menu item"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item")), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenu, {
    title: "L0 menu"
  }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item")), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavDivider, null), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavLink, {
    href: "javascript:void(0)"
  }, "L0 link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavLink, {
    href: "javascript:void(0)"
  }, "L0 link"))), /*#__PURE__*/_react.default.createElement(StoryContent, {
    useResponsiveOffset: false
  }));
});
exports.FixedSideNavWDivider = FixedSideNavWDivider;
FixedSideNavWDivider.storyName = 'Fixed SideNav w/ Divider';
var SideNavRail = (0, _storybookReadme.withReadme)(_README.default, function () {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_UIShell.SideNav, {
    "aria-label": "Side navigation",
    isRail: true
  }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavItems, null, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenu, {
    renderIcon: Fade16,
    title: "Category title"
  }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    "aria-current": "page",
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link")), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenu, {
    renderIcon: Fade16,
    title: "Category title"
  }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link")), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenu, {
    renderIcon: Fade16,
    title: "Category title"
  }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link")), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavLink, {
    renderIcon: Fade16,
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavLink, {
    renderIcon: Fade16,
    href: "javascript:void(0)"
  }, "Link"))), /*#__PURE__*/_react.default.createElement(StoryContent, null));
});
exports.SideNavRail = SideNavRail;
SideNavRail.storyName = 'SideNav Rail';
var SideNavRailWHeader = (0, _storybookReadme.withReadme)(_README.default, function () {
  return /*#__PURE__*/_react.default.createElement(_HeaderContainer.default, {
    render: function render(_ref6) {
      var isSideNavExpanded = _ref6.isSideNavExpanded,
          onClickSideNavExpand = _ref6.onClickSideNavExpand;
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_UIShell.Header, {
        "aria-label": "IBM Platform Name"
      }, /*#__PURE__*/_react.default.createElement(_UIShell.SkipToContent, null), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuButton, {
        "aria-label": "Open menu",
        isCollapsible: true,
        onClick: onClickSideNavExpand,
        isActive: isSideNavExpanded
      }), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderName, {
        href: "#",
        prefix: "IBM"
      }, "[Platform]"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderNavigation, {
        "aria-label": "IBM [Platform]"
      }, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Link 1"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Link 2"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Link 3"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenu, {
        "aria-label": "Link 4",
        menuLinkName: "Link 4"
      }, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 1"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 2"), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderMenuItem, {
        href: "#"
      }, "Sub-link 3"))), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderGlobalBar, null, /*#__PURE__*/_react.default.createElement(_UIShell.HeaderGlobalAction, {
        "aria-label": "Search",
        onClick: (0, _addonActions.action)('search click')
      }, /*#__PURE__*/_react.default.createElement(_iconsReact.Search20, null)), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderGlobalAction, {
        "aria-label": "Notifications",
        onClick: (0, _addonActions.action)('notification click')
      }, /*#__PURE__*/_react.default.createElement(_iconsReact.Notification20, null)), /*#__PURE__*/_react.default.createElement(_UIShell.HeaderGlobalAction, {
        "aria-label": "App Switcher",
        onClick: (0, _addonActions.action)('app-switcher click'),
        tooltipAlignment: "end"
      }, /*#__PURE__*/_react.default.createElement(_iconsReact.AppSwitcher20, null))), /*#__PURE__*/_react.default.createElement(_UIShell.SideNav, {
        "aria-label": "Side navigation",
        isRail: true,
        expanded: isSideNavExpanded,
        onOverlayClick: onClickSideNavExpand
      }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavItems, null, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenu, {
        renderIcon: Fade16,
        title: "Category title"
      }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        "aria-current": "page",
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link")), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenu, {
        renderIcon: Fade16,
        title: "Category title"
      }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        "aria-current": "page",
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link")), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenu, {
        renderIcon: Fade16,
        title: "Category title"
      }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        "aria-current": "page",
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link")), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavLink, {
        renderIcon: Fade16,
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavLink, {
        renderIcon: Fade16,
        href: "javascript:void(0)"
      }, "Link")))), /*#__PURE__*/_react.default.createElement(StoryContent, null));
    }
  });
});
exports.SideNavRailWHeader = SideNavRailWHeader;
SideNavRailWHeader.storyName = 'SideNav Rail w/Header';
var SideNavWLargeSideNavItems = (0, _storybookReadme.withReadme)(_README.default, function () {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_UIShell.SideNav, {
    expanded: true,
    isChildOfHeader: false,
    "aria-label": "Side navigation"
  }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavItems, null, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenu, {
    title: "Large menu",
    large: true
  }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Menu 1"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Menu 2"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Menu 3")), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavLink, {
    href: "javascript:void(0)",
    large: true
  }, "Large link"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenu, {
    renderIcon: Fade16,
    title: "Large menu w/icon",
    large: true
  }, /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Menu 1"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Menu 2"), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Menu 3")), /*#__PURE__*/_react.default.createElement(_UIShell.SideNavLink, {
    renderIcon: Fade16,
    href: "javascript:void(0)",
    large: true
  }, "Large link w/icon"))), /*#__PURE__*/_react.default.createElement(StoryContent, null));
});
exports.SideNavWLargeSideNavItems = SideNavWLargeSideNavItems;
SideNavWLargeSideNavItems.storyName = 'SideNav w/ large side nav items';