"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SideNavMenu = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _iconsReact = require("@carbon/icons-react");

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _SideNavIcon = _interopRequireDefault(require("../SideNavIcon"));

var _keyboard = require("../../../internal/keyboard");

var _usePrefix = require("../../../internal/usePrefix");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var SideNavMenu = /*#__PURE__*/_react.default.forwardRef(function SideNavMenu(props, ref) {
  var _cx;

  var customClassName = props.className,
      children = props.children,
      _props$defaultExpande = props.defaultExpanded,
      defaultExpanded = _props$defaultExpande === void 0 ? false : _props$defaultExpande,
      _props$isActive = props.isActive,
      isActive = _props$isActive === void 0 ? false : _props$isActive,
      _props$large = props.large,
      large = _props$large === void 0 ? false : _props$large,
      IconElement = props.renderIcon,
      isSideNavExpanded = props.isSideNavExpanded,
      title = props.title;
  var prefix = (0, _usePrefix.usePrefix)();

  var _useState = (0, _react.useState)(defaultExpanded),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      isExpanded = _useState2[0],
      setIsExpanded = _useState2[1];

  var _useState3 = (0, _react.useState)(defaultExpanded),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      prevExpanded = _useState4[0],
      setPrevExpanded = _useState4[1];

  var className = (0, _classnames.default)((_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--side-nav__item"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--side-nav__item--active"), isActive || hasActiveChild(children) && !isExpanded), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--side-nav__item--icon"), IconElement), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--side-nav__item--large"), large), (0, _defineProperty2.default)(_cx, customClassName, !!customClassName), _cx));

  if (isSideNavExpanded === false && isExpanded === true) {
    setIsExpanded(false);
    setPrevExpanded(true);
  } else if (isSideNavExpanded === true && prevExpanded === true) {
    setIsExpanded(true);
    setPrevExpanded(false);
  }

  return (
    /*#__PURE__*/
    // eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions
    _react.default.createElement("li", {
      className: className,
      onKeyDown: function onKeyDown(event) {
        if ((0, _keyboard.match)(event, _keyboard.keys.Escape)) {
          setIsExpanded(false);
        }
      }
    }, /*#__PURE__*/_react.default.createElement("button", {
      "aria-expanded": isExpanded,
      className: "".concat(prefix, "--side-nav__submenu"),
      onClick: function onClick() {
        setIsExpanded(!isExpanded);
      },
      ref: ref,
      type: "button"
    }, IconElement && /*#__PURE__*/_react.default.createElement(_SideNavIcon.default, null, /*#__PURE__*/_react.default.createElement(IconElement, null)), /*#__PURE__*/_react.default.createElement("span", {
      className: "".concat(prefix, "--side-nav__submenu-title")
    }, title), /*#__PURE__*/_react.default.createElement(_SideNavIcon.default, {
      className: "".concat(prefix, "--side-nav__submenu-chevron"),
      small: true
    }, /*#__PURE__*/_react.default.createElement(_iconsReact.ChevronDown20, null))), /*#__PURE__*/_react.default.createElement("ul", {
      className: "".concat(prefix, "--side-nav__menu")
    }, children))
  );
});

exports.SideNavMenu = SideNavMenu;
SideNavMenu.propTypes = {
  /**
   * Provide <SideNavMenuItem>'s inside of the `SideNavMenu`
   */
  children: _propTypes.default.node,

  /**
   * Provide an optional class to be applied to the containing node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether the menu should default to expanded. By default, it will
   * be closed.
   */
  defaultExpanded: _propTypes.default.bool,

  /**
   * Specify whether the `SideNavMenu` is "active". `SideNavMenu` should be
   * considered active if one of its menu items are a link for the current
   * page.
   */
  isActive: _propTypes.default.bool,

  /**
   * Property to indicate if the side nav container is open (or not). Use to
   * keep local state and styling in step with the SideNav expansion state.
   */
  isSideNavExpanded: _propTypes.default.bool,

  /**
   * Specify if this is a large variation of the SideNavMenu
   */
  large: _propTypes.default.bool,

  /**
   * Pass in a custom icon to render next to the `SideNavMenu` title
   */
  renderIcon: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object]),

  /**
   * Provide the text for the overall menu name
   */
  title: _propTypes.default.string.isRequired
};

function hasActiveChild(children) {
  // if we have children, either a single or multiple, find if it is active
  if (Array.isArray(children)) {
    return children.some(function (child) {
      if (!child.props) {
        return false;
      }

      if (child.props.isActive === true) {
        return true;
      }

      if (child.props['aria-current']) {
        return true;
      }

      return false;
    });
  }

  if (children.props) {
    if (children.props.isActive === true || children.props['aria-current']) {
      return true;
    }
  }

  return false;
}