/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Attribution: https://github.com/tobiasahlin/SpinKit
 *
 */
import React from 'react';
import 'spinkit/spinkit.min.css';
function classOf(cls, props) {
    return cls + (props.className ? ' ' + props.className : '');
}
export function Plane(props) {
    return React.createElement("div", { className: classOf('sk-plane', props) });
}
export function Chase(props) {
    return (React.createElement("div", { className: classOf('sk-chase', props) },
        React.createElement("div", { className: "sk-chase-dot" }),
        React.createElement("div", { className: "sk-chase-dot" }),
        React.createElement("div", { className: "sk-chase-dot" }),
        React.createElement("div", { className: "sk-chase-dot" }),
        React.createElement("div", { className: "sk-chase-dot" }),
        React.createElement("div", { className: "sk-chase-dot" })));
}
export function Bounce(props) {
    return (React.createElement("div", { className: classOf('sk-bounce', props) },
        React.createElement("div", { className: "sk-bounce-dot" }),
        React.createElement("div", { className: "sk-bounce-dot" })));
}
export function Wave(props) {
    return (React.createElement("div", { className: classOf('sk-wave', props) },
        React.createElement("div", { className: "sk-wave-rect" }),
        React.createElement("div", { className: "sk-wave-rect" }),
        React.createElement("div", { className: "sk-wave-rect" }),
        React.createElement("div", { className: "sk-wave-rect" }),
        React.createElement("div", { className: "sk-wave-rect" })));
}
export function Pulse(props) {
    return React.createElement("div", { className: classOf('sk-pulse', props) });
}
export function Flow(props) {
    return (React.createElement("div", { className: classOf('sk-flow', props) },
        React.createElement("div", { className: "sk-flow-dot" }),
        React.createElement("div", { className: "sk-flow-dot" }),
        React.createElement("div", { className: "sk-flow-dot" })));
}
export function Swing(props) {
    return (React.createElement("div", { className: classOf('sk-swing', props) },
        React.createElement("div", { className: "sk-swing-dot" }),
        React.createElement("div", { className: "sk-swing-dot" })));
}
export function Circle(props) {
    return (React.createElement("div", { className: classOf('sk-circle', props) },
        React.createElement("div", { className: "sk-circle-dot" }),
        React.createElement("div", { className: "sk-circle-dot" }),
        React.createElement("div", { className: "sk-circle-dot" }),
        React.createElement("div", { className: "sk-circle-dot" }),
        React.createElement("div", { className: "sk-circle-dot" }),
        React.createElement("div", { className: "sk-circle-dot" }),
        React.createElement("div", { className: "sk-circle-dot" }),
        React.createElement("div", { className: "sk-circle-dot" }),
        React.createElement("div", { className: "sk-circle-dot" }),
        React.createElement("div", { className: "sk-circle-dot" }),
        React.createElement("div", { className: "sk-circle-dot" }),
        React.createElement("div", { className: "sk-circle-dot" })));
}
export function CircleFade(props) {
    return (React.createElement("div", { className: classOf('sk-circle-fade', props) },
        React.createElement("div", { className: "sk-circle-fade-dot" }),
        React.createElement("div", { className: "sk-circle-fade-dot" }),
        React.createElement("div", { className: "sk-circle-fade-dot" }),
        React.createElement("div", { className: "sk-circle-fade-dot" }),
        React.createElement("div", { className: "sk-circle-fade-dot" }),
        React.createElement("div", { className: "sk-circle-fade-dot" }),
        React.createElement("div", { className: "sk-circle-fade-dot" }),
        React.createElement("div", { className: "sk-circle-fade-dot" }),
        React.createElement("div", { className: "sk-circle-fade-dot" }),
        React.createElement("div", { className: "sk-circle-fade-dot" }),
        React.createElement("div", { className: "sk-circle-fade-dot" }),
        React.createElement("div", { className: "sk-circle-fade-dot" })));
}
export function Grid(props) {
    return (React.createElement("div", { className: classOf('sk-grid', props) },
        React.createElement("div", { className: "sk-grid-cube" }),
        React.createElement("div", { className: "sk-grid-cube" }),
        React.createElement("div", { className: "sk-grid-cube" }),
        React.createElement("div", { className: "sk-grid-cube" }),
        React.createElement("div", { className: "sk-grid-cube" }),
        React.createElement("div", { className: "sk-grid-cube" }),
        React.createElement("div", { className: "sk-grid-cube" }),
        React.createElement("div", { className: "sk-grid-cube" }),
        React.createElement("div", { className: "sk-grid-cube" })));
}
export function FoldingCube(props) {
    return (React.createElement("div", { className: classOf('sk-fold', props) },
        React.createElement("div", { className: "sk-fold-cube" }),
        React.createElement("div", { className: "sk-fold-cube" }),
        React.createElement("div", { className: "sk-fold-cube" }),
        React.createElement("div", { className: "sk-fold-cube" })));
}
export function Wander(props) {
    return (React.createElement("div", { className: classOf('sk-wander', props) },
        React.createElement("div", { className: "sk-wander-cube" }),
        React.createElement("div", { className: "sk-wander-cube" }),
        React.createElement("div", { className: "sk-wander-cube" })));
}
//# sourceMappingURL=Spinner.js.map