"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.replay = replay;
exports.openNotebook = openNotebook;
exports.clientNotebooksDefinitionToElectron = clientNotebooksDefinitionToElectron;
exports.loadClientNotebooksMenuDefinition = loadClientNotebooksMenuDefinition;

var _electron = require("electron");

var _tell = _interopRequireDefault(require("./tell"));

var _encode = _interopRequireDefault(require("../repl/encode"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2021 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/** Open a new window or tab and replay the contents of the given `filepath` */
function replay(filepath, createWindow) {
  try {
    // if we have no open kui windows, open a new one; otherwise,
    // use a tab in an existing window
    if (_electron.webContents.getAllWebContents().length === 0) {
      createWindow(['replay', filepath]);
    } else {
      (0, _tell.default)(`replay ${(0, _encode.default)(filepath)}`, 'pexec');
    }
  } catch (err) {
    console.log(err);
  }
}
/** @return a menu item that opens the given notebook */


function openNotebook(createWindow, label, filepath) {
  return {
    label,
    click: () => replay(filepath, createWindow)
  };
}

function isNotebooksMenu(item) {
  const menu = item;
  return typeof menu.label === 'string' && Array.isArray(menu.submenu);
}

function isNotebookDefinitionMenuItem(item) {
  const nbItem = item;
  return typeof nbItem.notebook === 'string' && typeof nbItem.filepath === 'string';
}
/** We only need to replace the NotebookDefinitionMenuItem with calls to our `notebook` helper */


function clientNotebooksDefinitionToElectron(defn, notebook) {
  if (defn) {
    return Object.assign({}, {
      label: defn.label,
      submenu: defn.submenu.map(item => {
        if (isNotebooksMenu(item)) {
          return clientNotebooksDefinitionToElectron(item, notebook);
        } else if (isNotebookDefinitionMenuItem(item)) {
          // this is the only mogrifier
          return notebook(item.notebook, item.filepath);
        } else {
          // separator, no change
          return item;
        }
      })
    });
  }
}
/** @return the client's definition of a Notebooks menu */


function loadClientNotebooksMenuDefinition() {
  try {
    return require('@kui-shell/client/config.d/notebooks.json');
  } catch (err) {
    return undefined;
  }
}