"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fstat = void 0;

var _fs = require("fs");

var _core = require("@kui-shell/core");

/*
 * Copyright 2018 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

function readData(fullpath) {
  return new Promise((resolve, reject) => {
    (0, _fs.readFile)(fullpath, (err, data) => {
      if (err) {
        reject(err);
      } else {
        resolve(data.toString());
      }
    });
  });
}
/**
 * Kui command for fs.stat
 *
 */


const fstat = ({
  argvNoOptions,
  parsedOptions
}) => {
  const filepath = argvNoOptions[1];
  const viewer = 'open';
  const fullpath = (0, _core.expandHomeDir)(filepath);
  const prettyFullPath = fullpath.replace(new RegExp(`^${process.env.HOME}`), '~');
  return new Promise((resolve, reject) => {
    const handleError = err => {
      if (err.code === 'ENOENT') {
        if (parsedOptions['enoent-ok']) {
          // file does not exist; caller told us that's ok
          resolve({
            viewer,
            filepath,
            fullpath: prettyFullPath,
            isDirectory: false,
            size: 0,
            data: ''
          });
        }

        const error = new Error(err.message);
        error.stack = err.stack;
        error.code = 404;
        reject(error);
      } else {
        reject(err);
      }
    }; // note: stat not lstat, because we want to follow the link


    (0, _fs.stat)(fullpath, (err, stats) => __awaiter(void 0, void 0, void 0, function* () {
      if (err) {
        handleError(err);
      } else {
        resolve({
          viewer,
          filepath,
          fullpath: prettyFullPath,
          isDirectory: stats.isDirectory(),
          size: stats.size,
          data: !stats.isDirectory() && parsedOptions['with-data'] && !filepath.endsWith('.gz') && stats.size < 1024 * 1024 ? yield readData(fullpath) : ''
        });
      }
    }));
  });
};

exports.fstat = fstat;