"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _serverSide = require("./server-side");

var _delegates = require("../delegates");

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

/**
 * Generic registration for commands with boolean flags.
 *
 * @param boolean: 'abc' is treated as meaning all of -a, -b, and -c
 * are boolean flags
 *
 */
function withBooleanFlags(command, handler, booleans, booleans2) {
  this.listen(`/${command}`, handler, {
    flags: {
      boolean: (typeof booleans === 'string' ? booleans.split('') : booleans).concat(booleans2 || [])
    }
  });
}

function _default(registrar) {
  const on = withBooleanFlags.bind(registrar);
  on('vfs/ls', args => __awaiter(this, void 0, void 0, function* () {
    try {
      return yield (0, _serverSide.lsImpl)(args);
    } catch (err) {
      // no virtual (client-only) mount found; try contacting the
      // proxy server
      return args.REPL.qexec(args.command.replace('vfs ls', 'vfs _ls'));
    }
  }), 'AadcClhtrsS');
  on('vfs/fstat', args => __awaiter(this, void 0, void 0, function* () {
    try {
      return yield (0, _serverSide.fstatImpl)(args);
    } catch (err) {
      // no virtual (client-only) mount found; try contacting the
      // proxy server
      return args.REPL.qexec(args.command.replace('vfs fstat', 'vfs _fstat'));
    }
  }), ['with-data', 'enoent-ok']);
  on('vfs/fwrite', args => __awaiter(this, void 0, void 0, function* () {
    try {
      return yield (0, _serverSide.fwriteImpl)(args);
    } catch (err) {
      // no virtual (client-only) mount found; try contacting the
      // proxy server
      return args.REPL.qexec(args.command.replace('vfs fwrite', 'vfs _fwrite'), undefined, undefined, {
        data: args.execOptions.data
      });
    }
  }), 'data');
  on('rm', args => (0, _delegates.rm)(args, args.argvNoOptions[1], !!(args.parsedOptions.r || args.parsedOptions.R)).then(response => typeof response === 'string' ? response : true), 'frRidPvw');
  on('mkdir', args => (0, _delegates.mkdir)(args, args.argvNoOptions[1]).then(() => true), 'pv');
  on('rmdir', args => (0, _delegates.rmdir)(args, args.argvNoOptions[1]).then(() => true), 'p');
  on('cp', args => {
    const N = args.argvNoOptions.length;
    const srcs = args.argvNoOptions.slice(1, N - 1);
    const dst = args.argvNoOptions[N - 1];
    return (0, _delegates.cp)(args, srcs, dst);
  }, 'acfHiLnPpRvXs');
}