import React from 'react';
import ResourceTable from '../components/ResourceTable';
import { pexecInCurrentTab } from '@kui-shell/core';
import strings from './i18n';
export default function renderReact(data, node, command, wrapperClassName) {
    const uniqueKinds = [...new Set(data.items ? data.items.map(item => item.kind) : data.map(item => item.kind)),];
    const searchResource = () => {
        return (React.createElement("div", { className: wrapperClassName },
            React.createElement("div", { className: 'search--resource' },
                data.related && data.related.length > 0 && command.includes(':') ? (React.createElement("div", { className: 'related--resource-table-header' },
                    React.createElement("button", { onClick: () => {
                            console.log('button', command);
                            pexecInCurrentTab(`split --ifnot is-split --cmdline "${command.concat(' --related')}"`, undefined, false, true);
                        }, className: 'related--resource-table-header-button' },
                        React.createElement("div", { className: 'linked-resources' }, strings('search.label.view.related')),
                        React.createElement("span", { className: 'arrow-right' }, "\u2192")))) : null,
                uniqueKinds.map(kind => (React.createElement("div", { className: 'search--resource-table', key: kind.toString() },
                    React.createElement(ResourceTable, { items: data.items ? data.items.filter(item => item.kind === kind) : data.filter(item => item.kind === kind), kind: kind.toString() })))))));
    };
    return { react: React.createElement(searchResource) };
}
//# sourceMappingURL=renderReact.js.map