"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uuid = uuid;
exports.default = void 0;

var _core = require("@kui-shell/core");

/*
 * Copyright 2018 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/** cheapo uuid; we only need single-threaded uniqueness */
let _uuidCounter = 1;

function uuid() {
  return (_uuidCounter++).toString();
}

class TabModel {
  constructor(_uuid = uuid(), desiredStatusStripeDecoration, background, _title, _state = new _core.TabState(_uuid, desiredStatusStripeDecoration), _buttons = [], _initialCommandLine, _onClose, _exec, _snapshot) {
    this._uuid = _uuid;
    this.desiredStatusStripeDecoration = desiredStatusStripeDecoration;
    this._title = _title;
    this._state = _state;
    this._buttons = _buttons;
    this._initialCommandLine = _initialCommandLine;
    this._onClose = _onClose;
    this._exec = _exec;
    this._snapshot = _snapshot;

    this._state.capture();

    if (!background) {
      this._state.updateStatusStripe();
    }
  }

  get uuid() {
    return this._uuid;
  }

  get state() {
    return this._state;
  }

  get buttons() {
    return this._buttons;
  }

  get title() {
    return this._title;
  }

  get initialCommandLine() {
    return this._initialCommandLine;
  }

  get onClose() {
    return this._onClose;
  }

  get exec() {
    return this._exec;
  }

  get snapshot() {
    return this._snapshot;
  }

  update(buttons) {
    return new TabModel(this.uuid, undefined, undefined, this.title, this.state, buttons, undefined, this.onClose, undefined, this._snapshot);
  }

}

exports.default = TabModel;