"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = sortRow;
exports.isSortableCol = isSortableCol;

/*
 * Copyright 2021 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const byte = 1;
const kilobyte = 1024 * byte;
const megabyte = 1024 * kilobyte;
const gigabyte = 1024 * megabyte;
const terabyte = 1024 * gigabyte;
const petabyte = 1024 * terabyte;
const exabyte = 1024 * petabyte;
const sizes = {
  B: byte,
  K: kilobyte,
  M: megabyte,
  G: gigabyte,
  T: terabyte,
  P: petabyte,
  E: exabyte
};

function toSize(val) {
  const last = val.charAt(val.length - 1);
  const mult = sizes[last] || exabyte;
  return mult * parseInt(val.slice(0, val.length - 2), 10);
}

function sortBySize(rowA, rowB, cidx, dir) {
  const cellA = rowA.attributes[cidx - 1].value;
  const cellB = rowB.attributes[cidx - 1].value;
  return (toSize(cellA) - toSize(cellB)) * dir;
}

function sortRowWithDir(rowA, rowB, key, cidx, direction) {
  const dir = direction === 'asc' ? 1 : -1;

  if (key === 'SIZE') {
    return sortBySize(rowA, rowB, cidx, dir);
  } else {
    return rowA.name.localeCompare(rowB.name) * dir;
  }
}

function sortRow(rowA, rowB, key, cidx, direction) {
  return sortRowWithDir(rowA, rowB, key.toUpperCase(), cidx, direction);
}

function isSortableCol(key) {
  return /NAME|SIZE|NAMESPACE|OBJECT/i.test(key.toUpperCase());
}