"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactCore = require("@patternfly/react-core");

var _Markdown = _interopRequireDefault(require("../../../Content/Markdown"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class PatternflyCard extends _react.default.PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      isOpen: false
    };
  }

  renderDropDownItems(actions) {
    return actions.map((item, idx) => _react.default.createElement(_reactCore.DropdownItem, {
      key: idx,
      component: "button",
      onClick: item.handler,
      "data-mode": item.label
    }, item.label));
  }

  cardActions() {
    return _react.default.createElement(_reactCore.CardActions, null, this.props.inlineActions, this.props.actions && _react.default.createElement(_reactCore.Dropdown, {
      onSelect: () => this.setState({
        isOpen: !this.state.isOpen
      }),
      toggle: _react.default.createElement(_reactCore.KebabToggle, {
        onToggle: isOpen => {
          this.setState({
            isOpen
          });
        }
      }),
      isOpen: this.state.isOpen,
      isPlain: true,
      dropdownItems: this.renderDropDownItems(this.props.actions),
      position: 'right'
    }));
  }

  icon() {
    return _react.default.createElement(_reactCore.Brand, {
      src: this.props.icon,
      alt: "card icon",
      className: "kui--card-icon"
    });
  }
  /** card actions, icon and custom header node will be situated in Card Head */


  header() {
    return (this.props.header || this.props.icon || this.props.titleInHeader || this.props.bodyInHeader || this.props.inlineActions || this.props.actions) && _react.default.createElement(_reactCore.CardHeader, {
      className: "kui--card-header"
    }, _react.default.createElement(_reactCore.CardHeaderMain, null, this.props.header || this.props.icon && this.icon()), (this.props.inlineActions || this.props.actions) && this.cardActions(), _react.default.createElement("div", null, this.props.titleInHeader && this.title(), this.props.bodyInHeader && this.body()));
  }
  /** card footer */


  footer() {
    return this.props.footer && _react.default.createElement(_reactCore.CardFooter, {
      className: 'kui--card-footer' + (this.props.footerClassName ? ` ${this.props.footerClassName}` : '')
    }, this.props.footer);
  }

  title() {
    if (this.props.title) {
      return _react.default.createElement(_reactCore.CardTitle, {
        className: "kui--card-title"
      }, this.props.title);
    }
  }

  child(node) {
    if (typeof node === 'string') {
      return _react.default.createElement(_Markdown.default, {
        nested: true,
        source: node,
        repl: this.props.repl,
        baseUrl: this.props.baseUrl
      });
    } else {
      return node;
    }
  }

  body() {
    return _react.default.createElement(_reactCore.CardBody, {
      className: "kui--card-body"
    }, _react.default.Children.map(this.props.children, _ => this.child(_)));
  }

  dataProps() {
    return Object.keys(this.props).filter(_ => /^data-/.test(_)).reduce((M, key) => {
      M[key] = this.props[key];
      return M;
    }, {});
  }

  render() {
    const basicClassName = 'kui--card';
    return _react.default.createElement(_reactCore.Card, Object.assign({
      isCompact: true,
      onClick: this.props.onCardClick
    }, this.dataProps(), {
      className: !this.props.className ? basicClassName : `${basicClassName} ${this.props.className}`
    }), _react.default.Children.count(this.props.children) > 0 && _react.default.createElement(_react.default.Fragment, null, this.header(), !this.props.titleInHeader && this.title(), !this.props.bodyInHeader && this.body(), this.footer()));
  }

}

exports.default = PatternflyCard;