import { CommandStartEvent, CommandCompleteEvent, Notebook, Tab } from '@kui-shell/core';
import { CompleteBlock } from './Block/BlockModel';
/**
 * Split: captures the split uuid and blocks in a split
 *
 */
export declare type Split = {
    uuid: string;
    blocks: CompleteBlock[];
    inverseColors?: boolean;
};
declare type NotebookSpec = {
    spec: {
        splits: Split[];
    };
};
export declare type NotebookImpl = Notebook & NotebookSpec;
export declare function isNotebookImpl(raw: Record<string, any>): raw is NotebookImpl;
export declare function snapshot(block: CompleteBlock): CompleteBlock;
export declare function allocateTab(target: CommandStartEvent | CommandCompleteEvent, tab: Tab): void;
/** assign tab to the block */
export declare function tabAlignment(block: CompleteBlock, tab: Tab): CompleteBlock;
export declare class FlightRecorder {
    private readonly tab;
    private readonly splits;
    constructor(tab: Tab, splits: Split[]);
    private recordTable;
    /**
     * Run through the rows of a Table response, issue the onclick
     * handler, and store the (start,complete) event pairs, indexed by
     * row of the table; that's a ClickSnapshot.
     *
     */
    record(): Promise<void>;
}
export {};
