"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerApplySubcommands = registerApplySubcommands;
exports.default = registerForKubectl;
exports.viewLastApplied = void 0;

var _core = require("@kui-shell/core");

var _flags = require("./flags");

var _exec = require("./exec");

var _help = require("../../lib/util/help");

var _util = require("../../lib/util/util");

var _get = require("./get");

var _edit = require("./edit");

var _options = require("./options");

var _resource = require("../../lib/model/resource");

var _lastApplied = require("../../lib/view/modes/last-applied");

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};
/**
 * Notes: this file covers the three (as of this writing) subcommands
 * of apply:
 *  - view-last-applied
 *  - set-last-applied
 *  - edit-last-applied
 *
 */


const strings = (0, _core.i18n)('plugin-kubectl');
/** View Transformer for view-last-applied and edit-last-applied */

const viewLastApplied = subcommand => (args, response) => __awaiter(void 0, void 0, void 0, function* () {
  if ((0, _resource.isKubeResource)(response)) {
    if ((0, _lastApplied.hasLastApplied)(response)) {
      const baseView = yield (0, _get.doGetAsMMR)(args, response);

      if (subcommand === 'view-last-applied') {
        return Object.assign(baseView, {
          defaultMode: _lastApplied.mode
        });
      } else {
        const {
          content,
          contentType
        } = yield (0, _lastApplied.renderLastApplied)(args.tab, response);
        const spec = (0, _edit.editSpec)((0, _util.getCommandFromArgs)(args), response.metadata.namespace, args, response, 'set-last-applied');
        const editMode = {
          mode: _lastApplied.mode,
          label: _lastApplied.label,
          order: _lastApplied.order - 1,
          content,
          contentType,
          spec
        };
        return Object.assign(baseView, {
          modes: [editMode],
          defaultMode: _lastApplied.mode,
          toolbarText: (0, _edit.formatToolbarText)(args, response)
        });
      }
    } else {
      const error = new Error(strings('This resource has no last applied configuration'));
      error.code = 404;
      throw error;
    }
  }
});

exports.viewLastApplied = viewLastApplied;

function get(subcommand, args) {
  const command = (0, _util.getCommandFromArgs)(args);

  if ((0, _help.isUsage)(args)) {
    // special case: --help/-h
    return (0, _help.doHelp)(command === 'k' ? 'kubectl' : command, args);
  }

  const idx = args.argvNoOptions.indexOf(subcommand);
  const kind = args.argvNoOptions[idx + 1] || '';
  const name = args.argvNoOptions[idx + 2] || '';
  const file = args.parsedOptions.f || args.parsedOptions.filename;

  if (file) {
    return args.REPL.qexec(`${command} get -f ${file} ${(0, _options.getNamespaceForArgv)(args)} -o yaml`);
  } else {
    return args.REPL.qexec(`${command} get ${kind} ${name} ${(0, _options.getNamespaceForArgv)(args)} -o yaml`);
  }
}

function withTransformer(viewTransformer) {
  return Object.assign({}, _flags.flags, {
    viewTransformer
  });
}

function registerApplySubcommands(registrar, cmd) {
  registrar.listen(`/${cmd}/apply/view-last-applied`, get.bind(undefined, 'view-last-applied'), withTransformer(viewLastApplied('view-last-applied')));
  registrar.listen(`/${cmd}/apply/edit-last-applied`, get.bind(undefined, 'edit-last-applied'), withTransformer(viewLastApplied('edit-last-applied')));
  registrar.listen(`/${cmd}/apply/set-last-applied`, _exec.doExecWithPty);
}

function registerForKubectl(registrar) {
  registerApplySubcommands(registrar, 'kubectl');
  registerApplySubcommands(registrar, 'k');
}