"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.doRun = void 0;

var _flags = _interopRequireDefault(require("./flags"));

var _exec = require("./exec");

var _states = require("../../lib/model/states");

var _help = require("../../lib/util/help");

var _version = _interopRequireDefault(require("../../lib/util/version"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

/**
 * To get the status of a `run`, we look for the corresponding `deployment`
 *
 */
function prepareArgsForStatus(cmd, args) {
  return __awaiter(this, void 0, void 0, function* () {
    // before 1.16, kubectl run created a deployment; after, it creates a pod
    const {
      major,
      minor
    } = yield this;
    const kind = major === 1 && minor < 16 ? 'deployment' : 'pod';
    const name = args.argvNoOptions[args.argvNoOptions.indexOf(cmd) + 1];
    return [kind, name];
  });
}

const doRun = (command = 'kubectl') => args => {
  if ((0, _help.isUsage)(args)) {
    return (0, _help.doHelp)(command, args);
  } else {
    // this is intentionally async; we'll await it in prepareArgsForStatus
    const serverVersion = (0, _version.default)(args);
    const prepare = prepareArgsForStatus.bind(serverVersion);
    return (0, _exec.doExecWithStatus)('run', _states.FinalState.OnlineLike, command, undefined, prepare)(args);
  }
};

exports.doRun = doRun;

var _default = registrar => {
  const handler = doRun();
  registrar.listen('/kubectl/run', handler, _flags.default);
  registrar.listen('/k/run', handler, _flags.default);
};

exports.default = _default;