/// <reference types="react" />
import { Arguments, Button, Tab, ToolbarProps } from '@kui-shell/core';
import { Pod } from '../../model/resource';
import { Terminal, TerminalState } from './ExecIntoPod';
import { ContainerProps, StreamingStatus } from './ContainerCommon';
import { KubeOptions } from '../../../controller/kubectl/options';
import '../../../../web/scss/components/LogsSearch.scss';
interface State extends TerminalState {
    nLines: number;
    filter: Partial<string>;
    showingPrevious: boolean;
}
export declare function showingPrevious(args: Arguments<KubeOptions>): boolean;
export declare class Logs extends Terminal<State> {
    constructor(props: ContainerProps);
    protected supportsAllContainers(): boolean;
    protected mode(): string;
    /** Which container should we focus on by default? */
    protected defaultContainer(): string;
    /** Text to display in the Toolbar. */
    protected toolbarText(status: StreamingStatus): {
        type: "error" | "info" | "warning";
        text: string;
    };
    /** Addendum to toolbar text to denote whether we are showingPrevious */
    private previousMessage;
    /**
     *
     * @return whether we are showing logs for multiple containers,
     * e.g. via a label selector
     *
     */
    private isMulti;
    /**
     *
     * @return the command to issue in order to initialize the pty stream
     *
     */
    protected ptyCommand(): {
        command: string;
        isLive: "Live" | "Paused";
    };
    protected toolbarButtonsForStreaming(status: StreamingStatus): Button[];
    /** Previous logs button */
    private previous;
    protected toolbarButtons(status: StreamingStatus): Button[];
    /** The part of toggleStreaming that deals with PTY flow control. */
    private doFlowControl;
    /** Handler for Pause/Play. */
    private toggleStreaming;
    /** Should we wait a bit before proclaiming we have no data? */
    protected needsHysteresis(): boolean;
    /** Render the log content in the case we no logs to show. */
    protected nothingToShow(): JSX.Element;
    private readonly loglines;
    private delay;
    protected write(line: string): void;
    private refill;
    private delay2;
    private onFilterChange;
    private readonly _onFilterChange;
    private filterPane;
    render(): JSX.Element;
}
/**
 * The content renderer for the summary tab
 *
 */
export declare function content(tab: Tab, pod: Pod, args: Arguments<KubeOptions>): Promise<{
    react: (toolbarController: ToolbarProps) => JSX.Element;
}>;
export {};
