/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, ReplExpect, Selectors, Util } from '@kui-shell/test';
import { remotePodYaml, createNS, allocateNS, deleteNS, openSidecarByList } from '@kui-shell/plugin-kubectl/tests/lib/k8s/utils';
const commands = ['kubectl'];
if (process.env.NEEDS_OC) {
    commands.push('oc');
}
const file = remotePodYaml;
const name = 'nginx';
commands.forEach(command => {
    describe(`kubectl Events Sidecar button ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
        before(Common.before(this));
        after(Common.after(this));
        const ns = createNS();
        const inNamespace = `-n ${ns}`;
        allocateNS(this, ns);
        let res;
        let watchEventsRes;
        it('should create sample pod from URL', () => __awaiter(this, void 0, void 0, function* () {
            try {
                res = yield openSidecarByList(this, `${command} create -f ${file} ${inNamespace}`, name);
            }
            catch (err) {
                yield Common.oops(this, true)(err);
            }
        }));
        it('should click the show events button and expect an events table', () => __awaiter(this, void 0, void 0, function* () {
            try {
                yield Util.clickSidecarModeButton(this, res, 'events');
                watchEventsRes = ReplExpect.blockAfter(res);
                yield ReplExpect.okWithCustom({ selector: Selectors.TABLE_CELL(`pod/${name}`, 'OBJECT') })(watchEventsRes);
            }
            catch (err) {
                yield Common.oops(this, true)(err);
            }
        }));
        const currentEventCount = () => __awaiter(this, void 0, void 0, function* () {
            const events = yield this.app.client.$$(`${Selectors.OUTPUT_N(watchEventsRes.count, watchEventsRes.splitIndex)} ${Selectors.TABLE_CELL(`pod/${name}`, 'OBJECT')}`);
            return !events ? 0 : events.length;
        });
        it('should expect at least one event, since we just created the resource', () => {
            return this.app.client
                .waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                return (yield currentEventCount()) > 0;
            }))
                .catch(Common.oops(this, true));
        });
        it('should delete the resource via the terminal and see at least one new event', () => __awaiter(this, void 0, void 0, function* () {
            const eventCountBefore = yield currentEventCount();
            yield CLI.command(`kubectl delete -f ${file} ${inNamespace}`, this.app);
            yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                const eventCountAfter = yield currentEventCount();
                return eventCountAfter > eventCountBefore;
            }));
        }));
        deleteNS(this, ns);
    });
});
//# sourceMappingURL=events-sidecar-button.js.map