import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import cx from 'classnames';
import { usePrefix } from '../../internal/usePrefix';

function Item() {
  var prefix = usePrefix();
  return /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--breadcrumb-item")
  }, /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--link")
  }, "\xA0"));
}

function BreadcrumbSkeleton(_ref) {
  var className = _ref.className,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var classes = cx("".concat(prefix, "--breadcrumb"), "".concat(prefix, "--skeleton"), className);
  return /*#__PURE__*/React.createElement("div", _extends({
    className: classes
  }, rest), /*#__PURE__*/React.createElement(Item, null), /*#__PURE__*/React.createElement(Item, null), /*#__PURE__*/React.createElement(Item, null));
}

BreadcrumbSkeleton.propTypes = {
  /**
   * Specify an optional className to add.
   */
  className: PropTypes.string
};
export default BreadcrumbSkeleton;