import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["iconDescription", "className"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import classnames from 'classnames';
import { Copy16 } from '@carbon/icons-react';
import Copy from '../Copy';
import { usePrefix } from '../../internal/usePrefix';
export default function CopyButton(_ref) {
  var iconDescription = _ref.iconDescription,
      className = _ref.className,
      other = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  return /*#__PURE__*/React.createElement(Copy, _extends({
    className: classnames(className, "".concat(prefix, "--copy-btn")),
    "aria-label": iconDescription,
    title: iconDescription
  }, other), /*#__PURE__*/React.createElement(Copy16, {
    className: "".concat(prefix, "--snippet__icon")
  }));
}
CopyButton.propTypes = {
  /**
   * Specify an optional className to be applied to the underlying `<button>`
   */
  className: PropTypes.string,

  /**
   * Specify the string that is displayed when the button is clicked and the
   * content is copied
   */
  feedback: PropTypes.string,

  /**
   * Specify the time it takes for the feedback message to timeout
   */
  feedbackTimeout: PropTypes.number,

  /**
   * Provide a description for the icon representing the copy action that can
   * be read by screen readers
   */
  iconDescription: PropTypes.string,

  /**
   * Specify an optional `onClick` handler that is called when the underlying
   * `<button>` is clicked
   */
  onClick: PropTypes.func
};
CopyButton.defaultProps = {
  iconDescription: 'Copy to clipboard',
  feedback: 'Copied!',
  feedbackTimeout: 2000,
  onClick: function onClick() {}
};