import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["showHeaders"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/* eslint-disable no-console */
import React from 'react';
import { withKnobs, boolean } from '@storybook/addon-knobs';
import DataTableSkeleton from '../DataTableSkeleton';
import { headers } from '../DataTable/stories/shared';

var props = function props() {
  return {
    showHeaders: boolean('Show table headers', true),
    zebra: boolean('Use zebra stripe (zebra)', false),
    compact: boolean('Compact variant (compact)', false),
    showHeader: boolean('Show the Table Header (showHeader)', true),
    showToolbar: boolean('Show the Table Toolbar (showToolbar)', true)
  };
};

export default {
  title: 'Components/DataTable',
  decorators: [withKnobs],
  parameters: {
    component: DataTableSkeleton
  }
};
export var Skeleton = function Skeleton() {
  var _props = props(),
      showHeaders = _props.showHeaders,
      rest = _objectWithoutProperties(_props, _excluded);

  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: '800px'
    }
  }, /*#__PURE__*/React.createElement(DataTableSkeleton, _extends({}, rest, {
    headers: showHeaders ? headers : null
  })), /*#__PURE__*/React.createElement("br", null));
};
Skeleton.storyName = 'default';
Skeleton.parameters = {
  info: {
    text: "\n        Skeleton states are used as a progressive loading state while the user waits for content to load.\n\n        This example shows a skeleton state for a data table.\n      "
  }
};