import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "size", "inline"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import cx from 'classnames';
import deprecate from '../../prop-types/deprecate';
import { PropTypes as ListBoxPropTypes } from '../ListBox';
import { usePrefix } from '../../internal/usePrefix';

var DropdownSkeleton = function DropdownSkeleton(_ref) {
  var _cx;

  var className = _ref.className,
      size = _ref.size,
      inline = _ref.inline,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var wrapperClasses = cx(className, (_cx = {}, _defineProperty(_cx, "".concat(prefix, "--skeleton"), true), _defineProperty(_cx, "".concat(prefix, "--dropdown-v2"), true), _defineProperty(_cx, "".concat(prefix, "--list-box"), true), _defineProperty(_cx, "".concat(prefix, "--form-item"), true), _defineProperty(_cx, "".concat(prefix, "--list-box--").concat(size), size), _cx));
  return /*#__PURE__*/React.createElement("div", _extends({
    className: wrapperClasses
  }, rest), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--list-box__field")
  }, /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--list-box__label")
  })));
};

DropdownSkeleton.propTypes = {
  /**
   * Specify an optional className to add.
   */
  className: PropTypes.string,

  /**
   * Specify whether you want the inline version of this control
   */
  inline: deprecate(PropTypes.bool, "The `inline` prop has been deprecated and will\n    be removed in the next major release. To specify the inline variant of Dropdown, please use the `type` prop."),

  /**
   * Specify the size of the ListBox.
   */
  size: ListBoxPropTypes.ListBoxSize
};
export default DropdownSkeleton;