import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState } from 'react';
import Button from '../../Button';
import InlineLoading from '../';
export default {
  title: 'Components/InlineLoading',
  parameters: {
    component: InlineLoading
  }
};
export var _InlineLoading = function _InlineLoading() {
  return /*#__PURE__*/React.createElement(InlineLoading, {
    status: "active",
    iconDescription: "Active loading indicator",
    description: "Loading data..."
  });
};
export var UxExample = function UxExample() {
  function MockSubmission(_ref) {
    var children = _ref.children;

    var _useState = useState(false),
        _useState2 = _slicedToArray(_useState, 2),
        isSubmitting = _useState2[0],
        setIsSubmitting = _useState2[1];

    var _useState3 = useState(false),
        _useState4 = _slicedToArray(_useState3, 2),
        success = _useState4[0],
        setSuccess = _useState4[1];

    var _useState5 = useState('Submitting...'),
        _useState6 = _slicedToArray(_useState5, 2),
        description = _useState6[0],
        setDescription = _useState6[1];

    var _useState7 = useState('off'),
        _useState8 = _slicedToArray(_useState7, 2),
        ariaLive = _useState8[0],
        setAriaLive = _useState8[1];

    var handleSubmit = function handleSubmit() {
      setIsSubmitting(true);
      setAriaLive('assertive'); // Instead of making a real request, we mock it with a timer

      setTimeout(function () {
        setIsSubmitting(false);
        setSuccess(true);
        setDescription('Submitted!'); // To make submittable again, we reset the state after a bit so the user gets completion feedback

        setTimeout(function () {
          setSuccess(false);
          setDescription('Submitting...');
          setAriaLive('off');
        }, 1500);
      }, 2000);
    };

    return children({
      handleSubmit: handleSubmit,
      isSubmitting: isSubmitting,
      success: success,
      description: description,
      ariaLive: ariaLive
    });
  }

  return /*#__PURE__*/React.createElement(MockSubmission, null, function (_ref2) {
    var handleSubmit = _ref2.handleSubmit,
        isSubmitting = _ref2.isSubmitting,
        success = _ref2.success,
        description = _ref2.description,
        ariaLive = _ref2.ariaLive;
    return /*#__PURE__*/React.createElement("div", {
      style: {
        display: 'flex',
        width: '300px'
      }
    }, /*#__PURE__*/React.createElement(Button, {
      kind: "secondary",
      disabled: isSubmitting || success
    }, "Cancel"), isSubmitting || success ? /*#__PURE__*/React.createElement(InlineLoading, {
      style: {
        marginLeft: '1rem'
      },
      description: description,
      status: success ? 'finished' : 'active',
      "aria-live": ariaLive
    }) : /*#__PURE__*/React.createElement(Button, {
      onClick: handleSubmit
    }, "Submit"));
  });
};