import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

import React from 'react';
import PasswordInput from './PasswordInput';
import { mount, shallow } from 'enzyme';
import { settings } from 'carbon-components';
var prefix = settings.prefix;
describe('PasswordInput', function () {
  describe('renders as expected', function () {
    var wrapper = mount( /*#__PURE__*/React.createElement(PasswordInput, {
      id: "test",
      className: "extra-class",
      labelText: "testlabel",
      helperText: "testHelper",
      light: true,
      showPasswordLabel: "Show password",
      hidePasswordLabel: "Hide password"
    }));

    var passwordInput = function passwordInput() {
      return wrapper.find('input');
    };

    describe('input', function () {
      it('renders as expected', function () {
        expect(passwordInput().length).toBe(1);
      });
      it('should accept refs', function () {
        var MyComponent = /*#__PURE__*/function (_React$Component) {
          _inherits(MyComponent, _React$Component);

          var _super = _createSuper(MyComponent);

          function MyComponent(props) {
            var _this;

            _classCallCheck(this, MyComponent);

            _this = _super.call(this, props);
            _this.passwordInput = /*#__PURE__*/React.createRef();
            _this.focus = _this.focus.bind(_assertThisInitialized(_this));
            return _this;
          }

          _createClass(MyComponent, [{
            key: "focus",
            value: function focus() {
              this.passwordInput.current.focus();
            }
          }, {
            key: "render",
            value: function render() {
              return /*#__PURE__*/React.createElement(PasswordInput, {
                id: "test",
                labelText: "testlabel",
                ref: this.passwordInput
              });
            }
          }]);

          return MyComponent;
        }(React.Component);

        var container = document.createElement('div');
        container.id = 'container';
        document.body.appendChild(container);
        var wrapper = mount( /*#__PURE__*/React.createElement(MyComponent, null), {
          attachTo: document.querySelector('#container')
        });
        expect(document.activeElement.type).toBeUndefined();
        wrapper.instance().focus();
        expect(document.activeElement.type).toEqual('password');
      });
      it('has the expected classes', function () {
        expect(passwordInput().hasClass("".concat(prefix, "--text-input"))).toEqual(true);
      });
      it('should add extra classes that are passed via className', function () {
        expect(passwordInput().hasClass('extra-class')).toEqual(true);
      });
      it('has the expected classes for light', function () {
        wrapper.setProps({
          light: true
        });
        expect(passwordInput().hasClass("".concat(prefix, "--text-input--light"))).toEqual(true);
      });
      it('should set type as expected', function () {
        expect(passwordInput().props().type).toEqual('password');
        wrapper.find('button').simulate('click');
        expect(passwordInput().props().type).toEqual('text');
        wrapper.find('button').simulate('click');
        expect(passwordInput().props().type).toEqual('password');
      });
      it('should set value as expected', function () {
        expect(passwordInput().props().defaultValue).toEqual(undefined);
        wrapper.setProps({
          defaultValue: 'test'
        });
        expect(passwordInput().props().defaultValue).toEqual('test');
      });
      it('should set disabled as expected', function () {
        expect(passwordInput().props().disabled).toEqual(false);
        wrapper.setProps({
          disabled: true
        });
        expect(passwordInput().props().disabled).toEqual(true);
      });
      it('should set placeholder as expected', function () {
        expect(passwordInput().props().placeholder).not.toBeDefined();
        wrapper.setProps({
          placeholder: 'Enter text'
        });
        expect(passwordInput().props().placeholder).toEqual('Enter text');
      });
      it('should set password visibility toggle text as expected', function () {
        var _wrapper$props = wrapper.props(),
            hidePasswordLabel = _wrapper$props.hidePasswordLabel,
            showPasswordLabel = _wrapper$props.showPasswordLabel;

        wrapper.setProps({
          disabled: false
        });
        expect(wrapper.find('.bx--text-input--password__visibility__toggle').text()).toEqual(showPasswordLabel);
        wrapper.find('.bx--text-input--password__visibility__toggle').simulate('click');
        expect(wrapper.find('.bx--text-input--password__visibility__toggle').text()).toEqual(hidePasswordLabel);
      });
    });
    describe('label', function () {
      wrapper.setProps({
        labelText: 'Password Input'
      });
      var renderedLabel = wrapper.find('label');
      it('renders a label', function () {
        expect(renderedLabel.length).toBe(1);
      });
      it('has the expected classes', function () {
        expect(renderedLabel.hasClass("".concat(prefix, "--label"))).toEqual(true);
      });
      it('should set label as expected', function () {
        expect(renderedLabel.text()).toEqual('Password Input');
      });
    });
    describe('helper', function () {
      it('renders a helper', function () {
        var renderedHelper = wrapper.find(".".concat(prefix, "--form__helper-text"));
        expect(renderedHelper.length).toEqual(1);
      });
      it('renders children as expected', function () {
        wrapper.setProps({
          helperText: /*#__PURE__*/React.createElement("span", null, "This helper text has ", /*#__PURE__*/React.createElement("a", {
            href: "/"
          }, "a link"), ".")
        });
        var renderedHelper = wrapper.find(".".concat(prefix, "--form__helper-text"));
        expect(renderedHelper.props().children).toEqual( /*#__PURE__*/React.createElement("span", null, "This helper text has ", /*#__PURE__*/React.createElement("a", {
          href: "/"
        }, "a link"), "."));
      });
      it('should set helper text as expected', function () {
        wrapper.setProps({
          helperText: 'Helper text'
        });
        var renderedHelper = wrapper.find(".".concat(prefix, "--form__helper-text"));
        expect(renderedHelper.text()).toEqual('Helper text');
      });
    });
  });
  describe('events', function () {
    describe('disabled textinput', function () {
      var onClick = jest.fn();
      var onChange = jest.fn();
      var wrapper = shallow( /*#__PURE__*/React.createElement(PasswordInput, {
        id: "test",
        labelText: "testlabel",
        onClick: onClick,
        onChange: onChange,
        disabled: true
      }));
      var input = wrapper.find('input');
      it('should not invoke onClick', function () {
        input.simulate('click');
        expect(onClick).not.toHaveBeenCalled();
      });
      it('should not invoke onChange', function () {
        input.simulate('change');
        expect(onChange).not.toHaveBeenCalled();
      });
    });
    describe('enabled textinput', function () {
      var onClick = jest.fn();
      var onChange = jest.fn();
      var wrapper = shallow( /*#__PURE__*/React.createElement(PasswordInput, {
        labelText: "testlabel",
        id: "test",
        onClick: onClick,
        onChange: onChange
      }));
      var input = wrapper.find('input');
      var eventObject = {
        target: {
          defaultValue: 'test'
        }
      };
      it('should invoke onClick when input is clicked', function () {
        input.simulate('click');
        expect(onClick).toHaveBeenCalled();
      });
      it('should invoke onChange when input value is changed', function () {
        input.simulate('change', eventObject);
        expect(onChange).toHaveBeenCalledWith(eventObject);
      });
    });
  });
});