import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

var _defineProperty2, _defineProperty3;

var _excluded = ["id", "labelText", "className", "size"];

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import cx from 'classnames';
import { settings } from 'carbon-components';
var prefix = settings.prefix;

var ToggleSkeleton = /*#__PURE__*/function (_React$Component) {
  _inherits(ToggleSkeleton, _React$Component);

  var _super = _createSuper(ToggleSkeleton);

  function ToggleSkeleton() {
    _classCallCheck(this, ToggleSkeleton);

    return _super.apply(this, arguments);
  }

  _createClass(ToggleSkeleton, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          id = _this$props.id,
          labelText = _this$props.labelText,
          className = _this$props.className,
          size = _this$props.size,
          rest = _objectWithoutProperties(_this$props, _excluded);

      var toggleInputClassNames = cx("".concat(prefix, "--toggle ").concat(prefix, "--skeleton"), _defineProperty({}, "".concat(prefix, "--toggle-input--small"), size === 'sm'));
      return /*#__PURE__*/React.createElement("div", _extends({
        className: cx("".concat(prefix, "--form-item"), className)
      }, rest), /*#__PURE__*/React.createElement("input", {
        type: "checkbox",
        id: id,
        className: toggleInputClassNames
      }), /*#__PURE__*/React.createElement("label", {
        className: "".concat(prefix, "--toggle-input__label"),
        htmlFor: id,
        "aria-label": labelText ? null : this.props['aria-label']
      }, labelText ? /*#__PURE__*/React.createElement("div", null, labelText) : null, /*#__PURE__*/React.createElement("span", {
        className: "".concat(prefix, "--toggle__switch")
      }, /*#__PURE__*/React.createElement("span", {
        className: "".concat(prefix, "--toggle__text--left")
      }), /*#__PURE__*/React.createElement("span", {
        className: "".concat(prefix, "--toggle__appearance")
      }), /*#__PURE__*/React.createElement("span", {
        className: "".concat(prefix, "--toggle__text--right")
      }))));
    }
  }]);

  return ToggleSkeleton;
}(React.Component);

_defineProperty(ToggleSkeleton, "propTypes", (_defineProperty2 = {}, _defineProperty(_defineProperty2, 'aria-label', PropTypes.string.isRequired), _defineProperty(_defineProperty2, "className", PropTypes.string), _defineProperty(_defineProperty2, "id", PropTypes.string), _defineProperty(_defineProperty2, "labelText", PropTypes.string), _defineProperty(_defineProperty2, "size", PropTypes.oneOf(['sm', 'md'])), _defineProperty2));

_defineProperty(ToggleSkeleton, "defaultProps", (_defineProperty3 = {}, _defineProperty(_defineProperty3, 'aria-label', 'Toggle is loading'), _defineProperty(_defineProperty3, "size", 'md'), _defineProperty3));

export { ToggleSkeleton as default };