import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React, { useState, useCallback } from 'react'; // eslint-disable-next-line react/prop-types

var HeaderContainer = function HeaderContainer(_ref) {
  var isSideNavExpanded = _ref.isSideNavExpanded,
      Children = _ref.render;

  //state for expandable sidenav
  var _useState = useState(isSideNavExpanded),
      _useState2 = _slicedToArray(_useState, 2),
      isSideNavExpandedState = _useState2[0],
      setIsSideNavExpandedState = _useState2[1];

  var handleHeaderMenuButtonClick = useCallback(function () {
    setIsSideNavExpandedState(function (prevIsSideNavExpanded) {
      return !prevIsSideNavExpanded;
    });
  }, [setIsSideNavExpandedState]);
  return /*#__PURE__*/React.createElement(Children, {
    isSideNavExpanded: isSideNavExpandedState,
    onClickSideNavExpand: handleHeaderMenuButtonClick
  });
};

HeaderContainer.propTypes = {
  /**
   * Optionally provide a custom class name that is applied to the underlying <header>
   */
  isSideNavExpanded: PropTypes.bool
};
HeaderContainer.defaultProps = {
  isSideNavExpanded: false
};
export default HeaderContainer;