import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
/**
 * Generic component used for reacting to a click event happening outside of a
 * given child component that used the forwarded `handleRef` function through
 * the `refKey` prop.
 */

var InnerClickListener = /*#__PURE__*/function (_React$Component) {
  _inherits(InnerClickListener, _React$Component);

  var _super = _createSuper(InnerClickListener);

  function InnerClickListener(props) {
    var _this;

    _classCallCheck(this, InnerClickListener);

    _this = _super.call(this, props); // We manually bind handlers in this Component, versus using class
    // properties, so that we can properly test the `handleRef` handler with
    // enzyme.

    _this.handleRef = _this.handleRef.bind(_assertThisInitialized(_this));
    _this.handleDocumentClick = _this.handleDocumentClick.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(InnerClickListener, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      document.addEventListener('click', this.handleDocumentClick);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      document.removeEventListener('click', this.handleDocumentClick);
    }
  }, {
    key: "handleDocumentClick",
    value: function handleDocumentClick(event) {
      // Ensure that the target exists in the DOM before checking the element
      if (this.element && (this.element.ownerDocument === event.target || this.element.ownerDocument.body.contains(event.target))) {
        if (this.element.contains && !this.element.contains(event.target)) {
          this.props.onClickOutside(event);
        }
      }
    }
  }, {
    key: "handleRef",
    value: function handleRef(el) {
      this.element = el;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          refKey = _this$props.refKey,
          children = _this$props.children;
      return /*#__PURE__*/React.cloneElement(children, _defineProperty({}, refKey, this.handleRef));
    }
  }]);

  return InnerClickListener;
}(React.Component);

_defineProperty(InnerClickListener, "propTypes", {
  children: PropTypes.node.isRequired,
  onClickOutside: PropTypes.func.isRequired,
  refKey: PropTypes.string.isRequired
});

export { InnerClickListener as default };