"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _FeatureFlags = require("../FeatureFlags");

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["className", "small", "href", "size"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var ButtonSkeleton = function ButtonSkeleton(_ref) {
  var _cx;

  var className = _ref.className,
      small = _ref.small,
      href = _ref.href,
      size = _ref.size,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var enabled = (0, _FeatureFlags.useFeatureFlag)('enable-v11-release');
  var prefix = (0, _usePrefix.usePrefix)();
  var buttonClasses = (0, _classnames.default)(className, (_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--skeleton"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--btn"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--btn--sm"), small || size === 'sm'), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--btn--md"), size === 'field' || size === 'md'), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--btn--lg"), enabled ? size === 'xl' : size === 'lg'), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--btn--xl"), enabled ? size === '2xl' : size === 'xl'), _cx));

  var commonProps = _objectSpread({
    className: buttonClasses
  }, rest);

  var button = /*#__PURE__*/_react.default.createElement("div", commonProps);

  var anchor = /*#__PURE__*/_react.default.createElement("a", (0, _extends2.default)({}, commonProps, {
    href: href,
    role: "button"
  })); // eslint-disable-line


  return href ? anchor : button;
};

ButtonSkeleton.propTypes = {
  /**
   * Specify an optional className to add.
   */
  className: _propTypes.default.string,

  /**
   * Optionally specify an href for your Button to become an `<a>` element
   */
  href: _propTypes.default.string,

  /**
   * Specify the size of the button, from a list of available sizes.
   * For `default` buttons, this prop can remain unspecified or use `default`.
   * In the next major release of Carbon, `default`, `field`, and `small` will be removed
   */
  size: _propTypes.default.oneOf(['default', 'field', 'small', 'sm', 'md', 'lg', 'xl', '2xl']),

  /**
   * Specify whether the Button should be a small variant
   */
  small: _propTypes.default.bool
};
ButtonSkeleton.defaultProps = {
  small: false
};
var _default = ButtonSkeleton;
exports.default = _default;