"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withLayer = exports.Combobox = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _ = _interopRequireDefault(require("../"));

var _Layer = require("../../Layer");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var items = [{
  id: 'option-0',
  text: 'An example option that is really long to show what should be done to handle long text'
}, {
  id: 'option-1',
  text: 'Option 1'
}, {
  id: 'option-2',
  text: 'Option 2'
}, {
  id: 'option-3',
  text: 'Option 3 - a disabled item',
  disabled: true
}, {
  id: 'option-4',
  text: 'Option 4'
}, {
  id: 'option-5',
  text: 'Option 5'
}];
var _default = {
  title: 'Components/ComboBox',
  component: _.default
};
exports.default = _default;

var Combobox = function Combobox() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_.default, {
    onChange: function onChange() {},
    id: "carbon-combobox",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    placeholder: "Filter...",
    titleText: "ComboBox title",
    helperText: "Combobox helper text"
  }));
};

exports.Combobox = Combobox;

var withLayer = function withLayer() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_.default, {
    onChange: function onChange() {},
    id: "carbon-combobox",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    placeholder: "Filter...",
    titleText: "First Layer",
    helperText: "Combobox helper text"
  }), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.default, {
    onChange: function onChange() {},
    id: "carbon-combobox",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    placeholder: "Filter...",
    titleText: "Second Layer",
    helperText: "Combobox helper text"
  }), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.default, {
    onChange: function onChange() {},
    id: "carbon-combobox",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    placeholder: "Filter...",
    titleText: "Third Layer",
    helperText: "Combobox helper text"
  }))));
};

exports.withLayer = withLayer;