"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Usage = exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _iconsReact = require("@carbon/icons-react");

var _Button = _interopRequireDefault(require("../../Button"));

var _DataTable = _interopRequireWildcard(require("../../DataTable"));

var _shared = require("./shared");

var _DataTable2 = _interopRequireDefault(require("../DataTable.mdx"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var _default = {
  title: 'Components/DataTable/Batch Actions',
  component: _DataTable.default,
  subcomponents: {
    TableBatchAction: _DataTable.TableBatchAction,
    TableBatchActions: _DataTable.TableBatchActions,
    TableToolbar: _DataTable.TableToolbar,
    TableToolbarAction: _DataTable.TableToolbarAction,
    TableToolbarContent: _DataTable.TableToolbarContent,
    TableToolbarSearch: _DataTable.TableToolbarSearch,
    TableToolbarMenu: _DataTable.TableToolbarMenu,
    Table: _DataTable.Table,
    TableBody: _DataTable.TableBody,
    TableCell: _DataTable.TableCell,
    TableContainer: _DataTable.TableContainer,
    TableHead: _DataTable.TableHead,
    TableHeader: _DataTable.TableHeader,
    TableRow: _DataTable.TableRow
  },
  parameters: {
    docs: {
      page: _DataTable2.default
    }
  }
};
exports.default = _default;

var Usage = function Usage() {
  return /*#__PURE__*/_react.default.createElement(_DataTable.default, {
    rows: _shared.rows,
    headers: _shared.headers
  }, function (_ref) {
    var rows = _ref.rows,
        headers = _ref.headers,
        getHeaderProps = _ref.getHeaderProps,
        getRowProps = _ref.getRowProps,
        getSelectionProps = _ref.getSelectionProps,
        getToolbarProps = _ref.getToolbarProps,
        getBatchActionProps = _ref.getBatchActionProps,
        onInputChange = _ref.onInputChange,
        selectedRows = _ref.selectedRows,
        getTableProps = _ref.getTableProps,
        getTableContainerProps = _ref.getTableContainerProps;
    var batchActionProps = getBatchActionProps();
    return /*#__PURE__*/_react.default.createElement(_DataTable.TableContainer, (0, _extends2.default)({
      title: "DataTable",
      description: "With batch actions"
    }, getTableContainerProps()), /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbar, getToolbarProps(), /*#__PURE__*/_react.default.createElement(_DataTable.TableBatchActions, batchActionProps, /*#__PURE__*/_react.default.createElement(_DataTable.TableBatchAction, {
      tabIndex: batchActionProps.shouldShowBatchActions ? 0 : -1,
      renderIcon: _iconsReact.Delete16,
      onClick: (0, _shared.batchActionClick)(selectedRows)
    }, "Delete"), /*#__PURE__*/_react.default.createElement(_DataTable.TableBatchAction, {
      tabIndex: batchActionProps.shouldShowBatchActions ? 0 : -1,
      renderIcon: _iconsReact.Save16,
      onClick: (0, _shared.batchActionClick)(selectedRows)
    }, "Save"), /*#__PURE__*/_react.default.createElement(_DataTable.TableBatchAction, {
      tabIndex: batchActionProps.shouldShowBatchActions ? 0 : -1,
      renderIcon: _iconsReact.Download16,
      onClick: (0, _shared.batchActionClick)(selectedRows)
    }, "Download")), /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarContent, {
      "aria-hidden": batchActionProps.shouldShowBatchActions
    }, /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarSearch, {
      persistent: "true",
      tabIndex: batchActionProps.shouldShowBatchActions ? -1 : 0,
      onChange: onInputChange
    }), /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarMenu, {
      tabIndex: batchActionProps.shouldShowBatchActions ? -1 : 0
    }, /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarAction, {
      onClick: function onClick() {
        return alert('Alert 1');
      }
    }, "Action 1"), /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarAction, {
      onClick: function onClick() {
        return alert('Alert 2');
      }
    }, "Action 2"), /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarAction, {
      onClick: function onClick() {
        return alert('Alert 3');
      }
    }, "Action 3")), /*#__PURE__*/_react.default.createElement(_Button.default, {
      tabIndex: batchActionProps.shouldShowBatchActions ? -1 : 0,
      onClick: (0, _addonActions.action)('Add new row'),
      size: "small",
      kind: "primary"
    }, "Add new"))), /*#__PURE__*/_react.default.createElement(_DataTable.Table, getTableProps(), /*#__PURE__*/_react.default.createElement(_DataTable.TableHead, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableSelectAll, getSelectionProps()), headers.map(function (header, i) {
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableHeader, (0, _extends2.default)({
        key: i
      }, getHeaderProps({
        header: header
      })), header.header);
    }))), /*#__PURE__*/_react.default.createElement(_DataTable.TableBody, null, rows.map(function (row, i) {
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, (0, _extends2.default)({
        key: i
      }, getRowProps({
        row: row
      })), /*#__PURE__*/_react.default.createElement(_DataTable.TableSelectRow, getSelectionProps({
        row: row
      })), row.cells.map(function (cell) {
        return /*#__PURE__*/_react.default.createElement(_DataTable.TableCell, {
          key: cell.id
        }, cell.value);
      }));
    }))));
  });
};

exports.Usage = Usage;